/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.automerge;

import com.atlassian.bitbucket.pageobjects.element.AdminInheritanceSettings;
import com.atlassian.bitbucket.pageobjects.element.RepositorySettingsRestrictionBanner;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.atlassian.webdriver.bitbucket.page.automerge.AbstractAutoMergeSettingsPage;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class RepositoryAutoMergeSettingsPage
extends AbstractAutoMergeSettingsPage {
    private final String projectKey;
    private final String repoSlug;
    @ElementBy(cssSelector="input[type='checkbox']")
    private PageElement automergeCheckBox;
    @ElementBy(cssSelector="[data-testid=\"auto-merge-checkbox--checkbox-label\"]")
    private PageElement automergeEnabledCheckboxLabel;
    @ElementBy(id="ajax-error")
    private PageElement errorDialog;
    @ElementBy(cssSelector="div[role='radiogroup'] :first-child span")
    private PageElement inheritRadioLabel;
    @ElementBy(className="locked-settings-banner")
    private PageElement lockedSettingsBanner;
    @ElementBy(cssSelector="input[name='repo-settings-section'][value='DISABLED']")
    private PageElement radioSettingsDisabled;
    @ElementBy(cssSelector="input[name='repo-settings-section'][value='ENABLED']")
    private PageElement radioSettingsEnabled;
    @ElementBy(className="auto-merge-inheritance")
    private PageElement settingsInheritance;

    public RepositoryAutoMergeSettingsPage(String projectKey, String repoSlug) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    public void clickReloadOnErrorDialog() {
        Poller.waitUntilTrue((TimedQuery)this.errorDialog.timed().isVisible());
        this.errorDialog.find(By.className((String)"ok-button")).click();
    }

    public InheritRadioLabel getInheritRadioLabel() {
        Poller.waitUntilTrue((TimedQuery)this.inheritRadioLabel.timed().isVisible());
        return (InheritRadioLabel)this.pageBinder.bind(InheritRadioLabel.class, new Object[]{this.inheritRadioLabel});
    }

    private AdminInheritanceSettings getInheritanceSettings() {
        return (AdminInheritanceSettings)this.pageBinder.bind(AdminInheritanceSettings.class, new Object[]{this.settingsInheritance});
    }

    public RepositorySettingsRestrictionBanner getRestrictionBanner() {
        Poller.waitUntilTrue((TimedQuery)this.lockedSettingsBanner.timed().isVisible());
        return (RepositorySettingsRestrictionBanner)this.pageBinder.bind(RepositorySettingsRestrictionBanner.class, new Object[]{this.lockedSettingsBanner});
    }

    public boolean isInherited() {
        return this.getInheritanceSettings().isInheritingSettings();
    }

    public RepositoryAutoMergeSettingsPage setCustomSettings() {
        this.getInheritanceSettings().useCustomSettings();
        return this;
    }

    public String getUrl() {
        return "/projects/" + this.projectKey + "/repos/" + this.repoSlug + "/settings/auto-merge";
    }

    public void verifyDisabledCheckbox() {
        Poller.waitUntilFalse((TimedQuery)this.enabledCheckbox.timed().isEnabled());
    }

    public static class InheritRadioLabel
    extends AbstractElementPageObject {
        public InheritRadioLabel(@Nonnull PageElement container) {
            super(container);
        }

        public <T extends BaseSidebarPage> T clickProjectSettingsLink(Class<T> pageClass, String projectKey) {
            this.find(By.linkText((String)"project settings")).click();
            return (T)((BaseSidebarPage)this.pageBinder.bind(pageClass, new Object[]{projectKey}));
        }

        public String getText() {
            return this.container.getText();
        }

        public boolean hasProjectSettingsLink() {
            return this.find(By.linkText((String)"project settings")).isPresent();
        }
    }
}

