/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.GroupSelect;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.PermissionRow;
import com.atlassian.webdriver.bitbucket.element.UserSelect;
import com.atlassian.webdriver.bitbucket.page.PermissionsPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.utils.WebDriverUtil;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;

public class PermissionTable
extends LegacyElementPageObject {
    @Inject
    PageElementFinder elementFinder;
    private PermissionsPage.PermissionEntityType entityType;

    public PermissionTable(PageElement pageElement) {
        super(pageElement);
    }

    public PermissionTable(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public void waitUntilLoaded() {
        Poller.waitUntilTrue((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return PermissionTable.this.findAll(By.className((String)"spinner")).isEmpty();
            }
        }));
        String id = this.getAttribute("id");
        if (id.startsWith("user")) {
            this.entityType = PermissionsPage.PermissionEntityType.USER;
        } else if (id.startsWith("group")) {
            this.entityType = PermissionsPage.PermissionEntityType.GROUP;
        } else {
            throw new IllegalStateException("Cannot determine entityType for permission table. id=" + id);
        }
    }

    private List<PermissionRow> getRows() {
        return this.findAll(By.cssSelector((String)"tr[data-entity-id]"), PermissionRow.class);
    }

    public PermissionRow getRow(String objectId) {
        PermissionRow row = (PermissionRow)this.find(By.cssSelector((String)PermissionTable.rowSelector(objectId)), PermissionRow.class);
        Poller.waitUntilTrue((TimedQuery)row.timed().isVisible());
        return row;
    }

    public PermissionRow removeItem(String objectId) {
        return this.getRow(objectId).clickRemove();
    }

    public PermissionRow removeItemAndExpectError(String objectId) {
        return this.getRow(objectId).clickRemoveAndExpectError();
    }

    public void showAllRemoveButtons() {
        ElementUtils.displayAllDeleteButtons((JavascriptExecutor)WebDriverUtil.as((WebDriver)this.driver, JavascriptExecutor.class));
    }

    public PageElement getLoadMoreLink() {
        return this.find(By.className((String)"load-more"));
    }

    public boolean rowIsPresent(String objectId) {
        return this.findAll(By.cssSelector((String)PermissionTable.rowSelector(objectId))).size() > 0;
    }

    public PermissionTable selectItem(String name) {
        PageElement selectorContainer = this.find(By.className((String)"permission-multi-selector"));
        switch (this.entityType) {
            case USER: {
                ((UserSelect)((UserSelect)this.pageBinder.bind(UserSelect.class, new Object[]{selectorContainer})).type(name)).selectFirst();
                break;
            }
            case GROUP: {
                ((GroupSelect)((GroupSelect)this.pageBinder.bind(GroupSelect.class, new Object[]{selectorContainer})).type(name)).selectFirst();
            }
        }
        return this;
    }

    public PermissionTable selectPermission(Permission permission) {
        PageElement trigger = this.find(By.className((String)"permission-type-trigger"));
        trigger.click();
        this.elementFinder.find(By.id((String)trigger.getAttribute("aria-controls"))).find(By.cssSelector((String)("li[data-value=\"" + permission.name() + "\"] a"))).click();
        return this;
    }

    public PermissionTable clickAdd() {
        PageElement addButton = this.find(By.className((String)"add-button"));
        int originalCount = this.getRows().size();
        addButton.click();
        Poller.waitUntil((String)"Wait until rows are added", (TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Integer>(){

            public Integer get() {
                return PermissionTable.this.getRows().size();
            }
        }), (Matcher)Matchers.allOf((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(originalCount)), (Matcher)Matchers.not((Object)0)));
        return this;
    }

    public PermissionTable clickAddExpectingError() {
        PageElement addButton = this.find(By.className((String)"add-button"));
        addButton.click();
        Poller.waitUntilTrue((TimedQuery)this.find(By.className((String)"error-message")).timed().isVisible());
        return this;
    }

    private static String rowSelector(String objectId) {
        return String.format("tr[data-entity-id=\"%s\"]:not(.permission-error)", objectId);
    }

    public List<String> getErrors() {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)Iterables.concat((Iterable)this.findAll(By.className((String)"permission-error")), (Iterable)this.findAll(By.className((String)"error-message"))), (Function)new Function<PageElement, String>(){

            public String apply(PageElement error) {
                return error.getText();
            }
        }));
    }
}

