/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.bitbucket.pageobjects.element.Changes;
import com.atlassian.bitbucket.pageobjects.element.CommitAuthorAvatar;
import com.atlassian.bitbucket.pageobjects.element.CommitSummary;
import com.atlassian.bitbucket.pageobjects.element.commit.details.CommitDetailsSummaryPanel;
import com.atlassian.bitbucket.pageobjects.element.commit.signature.CommitSignatureDialog;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.util.KeyboardShortcuts;
import com.atlassian.webdriver.bitbucket.util.Locators;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class CommitDetailsPage
extends BaseRepositoryPage {
    private final String commitId;
    @ElementBy(className="commit-changes")
    private PageElement changes;
    @ElementBy(className="author-and-committer")
    private PageElement commitAuthorAvatar;
    @ElementBy(className="commit-message")
    private PageElement commitMessage;
    @ElementBy(className="commit-summary")
    private PageElement commitSummary;
    @ElementBy(className="commit-details-summary-panel")
    private PageElement summaryPanel;

    public CommitDetailsPage(String projectKey, String repoSlug, String commitId) {
        super(projectKey, repoSlug);
        this.commitId = commitId;
    }

    public Changes getChanges() {
        return (Changes)this.pageBinder.bind(Changes.class, new Object[]{this.changes});
    }

    public CommitAuthorAvatar getCommitAuthorAvatar() {
        return (CommitAuthorAvatar)this.pageBinder.bind(CommitAuthorAvatar.class, new Object[]{this.commitAuthorAvatar});
    }

    public String getCommitMessage() {
        return this.commitMessage.getText();
    }

    public CommitSummary getCommitSummary() {
        return (CommitSummary)this.pageBinder.bind(CommitSummary.class, new Object[]{this.commitSummary});
    }

    public PageElement getEmoticonAutocomplete() {
        return this.elementFinder.find(By.className((String)"editor-autocomplete"), TimeoutType.DIALOG_LOAD);
    }

    public CommitDetailsSummaryPanel getSummaryPanel() {
        return (CommitDetailsSummaryPanel)this.pageBinder.bind(CommitDetailsSummaryPanel.class, new Object[]{this.summaryPanel});
    }

    public TimedCondition hasJiraIssuesDialog() {
        return this.elementFinder.find(By.id((String)"jira-issues-dialog")).timed().isVisible();
    }

    public void openJiraIssueDialogWithKeyboardShortcut() {
        KeyboardShortcuts.press(this.elementFinder.find(Locators.body()), Keys.chord((CharSequence[])new CharSequence[]{Keys.SHIFT, "j"}));
    }

    public String getUrl() {
        return "/projects/" + this.projectKey + "/repos/" + this.slug + "/commits/" + this.commitId;
    }

    public Boolean isVerified() {
        return this.elementFinder.find(By.cssSelector((String)".commit-signature.verified")).isPresent();
    }

    public CommitSignatureDialog openCommitSignatureVerificationDialog() {
        this.elementFinder.find(By.className((String)"verified")).click();
        PageElement commitSignatureDialog = this.elementFinder.find(By.cssSelector((String)"[data-testid='commit-signature-dialog']"));
        return (CommitSignatureDialog)this.pageBinder.bind(CommitSignatureDialog.class, new Object[]{commitSignatureDialog});
    }
}

