/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.commit.details;

import com.atlassian.bitbucket.pageobjects.element.commit.details.CommitPullRequestListDialog;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.DeploymentDetailsModal;
import com.google.inject.Inject;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class CommitDetailsSummaryPanel
extends AbstractElementPageObject {
    private final PageElement branchLink = this.find(By.cssSelector((String)"[data-testid='commit-branches']"));
    private final PageElement deploymentsLink = this.find(By.cssSelector((String)"[data-testid='deployments-summary']"));
    private final PageElement jiraIssueLink = this.find(By.cssSelector((String)"[data-testid='jira-issues-summary']"));
    private final PageElement parentCommitsWrapper = this.find(By.className((String)"parent-commits"));
    private final PageElement pullRequestLink = this.find(By.cssSelector((String)"[data-testid='commit-pull-requests']"));
    private final PageElement sourceLink = this.find(By.cssSelector((String)"[data-testid='download-commit']"));
    private final PageElement watchButton = this.find(By.cssSelector((String)"[data-testid='watch-commit']"));
    @Inject
    private PageElementFinder elementFinder;

    public CommitDetailsSummaryPanel(@Nonnull PageElement container) {
        super(container);
    }

    public void clickBranchLink() {
        Poller.waitUntilTrue((TimedQuery)this.branchLink.timed().isVisible());
        this.branchLink.click();
    }

    public List<PageElement> getBranches() {
        return this.elementFinder.findAll(By.cssSelector((String)"[data-testid='commit-branch']"));
    }

    public PageElement getBranchLink() {
        Poller.waitUntilTrue((TimedQuery)this.branchLink.timed().isVisible());
        return this.branchLink;
    }

    public PageElement getDeploymentsLink() {
        Poller.waitUntilTrue((TimedQuery)this.deploymentsLink.timed().isVisible());
        return this.deploymentsLink;
    }

    public String getDownloadLink() {
        Poller.waitUntilTrue((TimedQuery)this.sourceLink.timed().isVisible());
        return this.sourceLink.getAttribute("href");
    }

    public PageElement getJiraIssueLink() {
        Poller.waitUntilTrue((TimedQuery)this.jiraIssueLink.timed().isVisible());
        return this.jiraIssueLink;
    }

    public List<PageElement> getParents() {
        if (this.isMerge()) {
            this.getCommitParentsOverflowTrigger().click();
        }
        return this.parentCommitsWrapper.findAll(By.cssSelector((String)".commit-hash"));
    }

    public PageElement getPullRequestLink() {
        Poller.waitUntilTrue((TimedQuery)this.pullRequestLink.timed().isVisible());
        return this.pullRequestLink;
    }

    public TimedCondition hasJiraLink() {
        return this.jiraIssueLink.timed().isVisible();
    }

    public boolean hasPullRequestLink() {
        return (Boolean)this.pullRequestLink.timed().isVisible().byDefaultTimeout();
    }

    public boolean hasDeploymentsLink() {
        return (Boolean)this.deploymentsLink.timed().isVisible().byDefaultTimeout();
    }

    public boolean isMerge() {
        return this.getCommitParentsOverflowTrigger().isPresent();
    }

    public boolean isWatching() {
        return this.watchButton.find(By.cssSelector((String)"span + span")).getText().equals("Unwatch");
    }

    public DeploymentDetailsModal openDeploymentsDialog() {
        Poller.waitUntilTrue((TimedQuery)this.deploymentsLink.timed().isVisible());
        this.deploymentsLink.click();
        PageElement commitDeploymentsDialog = this.elementFinder.find(By.className((String)"deployments-dialog"));
        Poller.waitUntilTrue((TimedQuery)commitDeploymentsDialog.timed().isVisible());
        return (DeploymentDetailsModal)this.pageBinder.bind(DeploymentDetailsModal.class, new Object[]{commitDeploymentsDialog});
    }

    public CommitPullRequestListDialog openPullRequestListDialog() {
        CommitPullRequestListDialog dialog = this.openPullRequestListDialogWithoutWaitingForEvent();
        Poller.waitUntilTrue((TimedQuery)dialog.getPullRequestList().isVisible());
        return dialog;
    }

    public CommitPullRequestListDialog openPullRequestListDialogWithoutWaitingForEvent() {
        Poller.waitUntilTrue((TimedQuery)this.pullRequestLink.timed().isVisible());
        this.pullRequestLink.click();
        PageElement commitPullRequestListDialog = this.elementFinder.find(By.className((String)"pull-requests-modal"));
        Poller.waitUntilTrue((TimedQuery)commitPullRequestListDialog.timed().isVisible());
        CommitPullRequestListDialog dialog = (CommitPullRequestListDialog)this.pageBinder.bind(CommitPullRequestListDialog.class, new Object[]{commitPullRequestListDialog});
        Poller.waitUntilTrue((TimedQuery)dialog.isOpen());
        return dialog;
    }

    public void toggleWatching() {
        Poller.waitUntilTrue((TimedQuery)this.watchButton.timed().isVisible());
        this.watchButton.click();
    }

    private PageElement getCommitParentsOverflowTrigger() {
        return this.parentCommitsWrapper.find(By.className((String)"commit-parents-overflow-trigger"));
    }
}

