/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.pullrequesttemplate;

import com.atlassian.bitbucket.pageobjects.element.CodeMirrorEditor;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import java.util.Optional;

public class PullRequestTemplateAdminPage
extends BaseSidebarPage {
    private final String url;
    @ElementBy(cssSelector=".pull-request-templates-page .cancel-button")
    private PageElement cancelButton;
    @ElementBy(cssSelector=".pull-request-templates-page .editor")
    private PageElement descriptionEditor;
    @ElementBy(cssSelector=".pull-request-templates-page input[type=radio][value='DEFAULT']")
    private PageElement disabledRadio;
    @ElementBy(cssSelector=".pull-request-templates-page input[type=radio][value='CUSTOM']")
    private PageElement enabledRadio;
    @ElementBy(cssSelector=".pull-request-templates-page .admin-inheritance-settings input[type=radio][value='REPOSITORY']")
    private PageElement inheritDisabledRadio;
    @ElementBy(cssSelector=".pull-request-templates-page .admin-inheritance-settings input[type=radio][value='PROJECT']")
    private PageElement inheritEnabledRadio;
    @ElementBy(cssSelector=".pull-request-templates-page .save-button")
    private PageElement submitButton;
    @ElementBy(cssSelector=".editor-autocomplete")
    private PageElement userAutoCompleteList;

    public PullRequestTemplateAdminPage(String url) {
        this.url = url;
    }

    public PullRequestTemplateAdminPage cancel() {
        this.cancelButton.click();
        return this;
    }

    public PullRequestTemplateAdminPage enable(boolean enabled) {
        PageElement radio = enabled ? this.enabledRadio : this.disabledRadio;
        radio.click();
        return this;
    }

    public PullRequestTemplateAdminPage enterDescription(String description) {
        this.getDescriptionEditor().setText(description);
        return this;
    }

    public String getDescription() {
        return this.getDescriptionEditor().getText();
    }

    public CodeMirrorEditor getDescriptionEditor() {
        return (CodeMirrorEditor)this.pageBinder.bind(CodeMirrorEditor.class, new Object[]{this.descriptionEditor});
    }

    public String getUrl() {
        return this.url;
    }

    public TimedCondition getUserAutoCompleteList() {
        return this.userAutoCompleteList.timed().isVisible();
    }

    public PullRequestTemplateAdminPage inherit(boolean inherit) {
        PageElement radio = inherit ? this.inheritEnabledRadio : this.inheritDisabledRadio;
        radio.click();
        return this;
    }

    public boolean isDescriptionDisabled() {
        return this.getDescriptionEditor().isDisabled();
    }

    public boolean isEnabled() {
        return this.enabledRadio.isSelected();
    }

    public boolean isTemplateBehaviourDisabled() {
        return Optional.ofNullable(this.enabledRadio.getAttribute("disabled")).isPresent() && Optional.ofNullable(this.disabledRadio.getAttribute("disabled")).isPresent();
    }

    public PullRequestTemplateAdminPage submit() {
        this.submitButton.click();
        Poller.waitUntilFalse((TimedQuery)this.submitButton.timed().hasAttribute("data-has-overlay", "true"));
        return this;
    }
}

