/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mirror;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.MirrorConfigPage;
import javax.inject.Inject;

public class MirrorRequestDialog {
    private static final String AUTHORIZE_BUTTON_TEXT = "Authorize";
    private static final String DECLINE_BUTTON_TEXT = "Decline";
    private final String type;
    private final String mirrorId;
    @Inject
    private PageBinder pageBinder;
    @ElementBy(xpath="//*[@id='mirroring-upstream-container']//button[contains(.,'Authorize')]")
    private PageElement approveButton;
    @ElementBy(id="mirroring-upstream-container", timeoutType=TimeoutType.SLOW_PAGE_LOAD)
    private PageElement container;
    @ElementBy(xpath="//*[@id='mirroring-upstream-container']//button[contains(.,'Decline')]")
    private PageElement declineButton;

    public MirrorRequestDialog(String type, String mirrorId) {
        this.type = type;
        this.mirrorId = mirrorId;
    }

    @WaitUntil
    public void waitForLoad() {
        Poller.waitUntilTrue((TimedQuery)this.container.timed().isPresent());
    }

    public MirrorConfigPage clickApprove() {
        this.approveButton.click();
        return (MirrorConfigPage)this.pageBinder.bind(MirrorConfigPage.class, new Object[]{this.type, this.mirrorId});
    }

    public TimedCondition isLoaded() {
        return this.approveButton.timed().isPresent();
    }
}

