/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.page.BaseMergeStrategiesSettingsPage;
import org.openqa.selenium.By;

public class RepositoryMergeStrategiesSettingsPage
extends BaseMergeStrategiesSettingsPage {
    private final String projectKey;
    private final String slug;

    public RepositoryMergeStrategiesSettingsPage(String projectKey, String slug) {
        this.projectKey = projectKey;
        this.slug = slug;
    }

    public InheritSetting getInheritSetting() {
        for (InheritSetting setting : InheritSetting.values()) {
            if (!this.getElementForInherited(setting).isSelected()) continue;
            return setting;
        }
        throw new IllegalStateException("Project settings inheritance toggle is in an unexpected state");
    }

    public String getUrl() {
        return String.format("/projects/%s/repos/%s/settings/merge-strategies", this.projectKey, this.slug);
    }

    public boolean hasInheritSettingToggle() {
        return !this.mergeConfig.findAll(By.className((String)"inherit-settings-toggle")).isEmpty();
    }

    public boolean hasRestrictionBanner() {
        return this.elementFinder.find(By.className((String)"locked-settings-banner")).isPresent();
    }

    public boolean isMergeConfigFormEnabled() {
        return this.mergeConfig.find(By.className((String)"save-button")).getAttribute("disabled") == null;
    }

    public void setInherited(InheritSetting setting) {
        this.getElementForInherited(setting).click();
    }

    private PageElement getElementForInherited(InheritSetting setting) {
        switch (setting) {
            case CUSTOM: {
                return this.mergeConfig.find(By.cssSelector((String)"input[name='inherit-settings'][value='REPOSITORY']"));
            }
            case INHERIT: {
                return this.mergeConfig.find(By.cssSelector((String)"input[name='inherit-settings'][value='PROJECT']"));
            }
        }
        throw new IllegalArgumentException("Unhandled InheritSetting value: " + (Object)((Object)setting));
    }

    public static enum InheritSetting {
        CUSTOM,
        INHERIT;

    }
}

