/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.FileFinder;
import com.atlassian.webdriver.bitbucket.element.FileTable;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.RepositoryNotificationSettingsDialog;
import com.atlassian.webdriver.bitbucket.element.label.LabelList;
import com.atlassian.webdriver.bitbucket.page.FileLayoutPage;
import com.atlassian.webdriver.bitbucket.page.FileSourcePage;
import com.atlassian.webdriver.bitbucket.util.UrlUtils;
import com.google.common.base.Supplier;
import java.util.List;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;

public class FileBrowserPage
extends FileLayoutPage {
    private static final String PARENT_DIR = "..";
    private final Integer line;
    @ElementBy(id="browse-table", pageElementClass=FileTable.class)
    private FileTable fileTable;
    @ElementBy(id="repository-protocol-selector", pageElementClass=CloneRepo.class)
    private CloneRepo cloneRepo;
    @ElementBy(className="watch-repository-button")
    private PageElement watchRepositoryButton;
    @Inject
    private Timeouts timeouts;

    public FileBrowserPage(String projectKey, String repoSlug) {
        this(projectKey, repoSlug, "");
    }

    public FileBrowserPage(String projectKey, String repoSlug, String path) {
        this(projectKey, repoSlug, path, (String)null);
    }

    public FileBrowserPage(String projectKey, String repoSlug, String path, String at) {
        this(projectKey, repoSlug, path, at, null);
    }

    public FileBrowserPage(String projectKey, String repoSlug, String path, String at, Integer line) {
        super(projectKey, repoSlug, path, new FileLayoutPage.RevisionSpecifier(at, null));
        this.line = line;
    }

    @Override
    protected String getPathComponent() {
        return "browse";
    }

    private void clickFileOrFolder(String fileName) {
        FileTable.FileRow row = this.fileTable.findByFileName(fileName);
        row.getFileLink().click();
    }

    public FileSourcePage clickFile(String fileName) {
        this.clickFileOrFolder(fileName);
        return (FileSourcePage)this.pageBinder.bind(FileSourcePage.class, new Object[]{this.projectKey, this.slug, this.path + "/" + fileName});
    }

    public FileBrowserPage clickFolder(String fileName) {
        String parentPath = fileName.equals(PARENT_DIR) ? this.path.substring(0, this.path.lastIndexOf("/")) : this.path + "/" + fileName;
        return this.clickFolder(fileName, parentPath);
    }

    public FileBrowserPage clickFolder(String fileName, String newPath) {
        this.clickFileOrFolder(fileName);
        FileBrowserPage page = (FileBrowserPage)this.pageBinder.bind(FileBrowserPage.class, new Object[]{this.projectKey, this.slug, newPath});
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.id((String)"browse-table")).find(By.linkText((String)fileName)).timed().isPresent());
        return page;
    }

    public FileBrowserPage clickParentDir() {
        return this.clickFolder(PARENT_DIR);
    }

    public RepositoryNotificationSettingsDialog clickWatchRepositoryButton() {
        this.watchRepositoryButton.click();
        PageElement dialog = this.elementFinder.find(By.id((String)"watch-repository-settings-dialog"));
        Poller.waitUntilTrue((String)"The repository notification settings dialog should be open", (TimedQuery)Conditions.forSupplier((long)5000L, () -> ((PageElement)dialog).isPresent()));
        return (RepositoryNotificationSettingsDialog)this.pageBinder.bind(RepositoryNotificationSettingsDialog.class, new Object[]{dialog});
    }

    public boolean isWatching() {
        return this.watchRepositoryButton.find(By.className((String)"aui-icon-small")).hasClass("aui-iconfont-watch-filled");
    }

    public List<FileTable.FileRow> getFileRows() {
        return this.fileTable.getRows();
    }

    public PageElement getSynchronizeButton() {
        return this.elementFinder.find(By.className((String)"synchronize-ref"));
    }

    public boolean hasParentPathInTable() {
        return this.doesHaveFile(PARENT_DIR);
    }

    public boolean doesHaveFile(String fileName) {
        return this.fileTable.findByFileName(fileName) != null;
    }

    public String getBranchNameFromUrl() {
        return UrlUtils.getReferenceNameFromUrlParameter("at", this.driver.getCurrentUrl());
    }

    public void moveToNextFile(boolean isFileFinder) {
        if (isFileFinder) {
            this.getFileFinder().moveToNextResult();
        } else {
            this.useShortcut("j");
        }
    }

    public void moveToPrevFile(boolean isFileFinder) {
        if (isFileFinder) {
            this.getFileFinder().moveToPrevResult();
        } else {
            this.useShortcut("k");
        }
    }

    public void openParentDirectory(String expectedFileName) {
        this.useShortcut("u");
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.linkText((String)expectedFileName)).timed().isVisible());
    }

    public void openFocusedFile(String fileName) {
        this.openFocusedFile(fileName, "o");
    }

    public void switchToFileFinder() {
        this.useShortcut("f");
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"file-finder-table")).timed().isVisible());
    }

    public void switchToFileBrowser() {
        this.useShortcut((CharSequence)Keys.ESCAPE);
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"filebrowser-table")).timed().isVisible());
    }

    public FileSourcePage openFileSource(String filePath) {
        for (FileTable.FileRow row : this.getFileRows()) {
            String path = row.getFileName();
            if (!path.endsWith(filePath)) continue;
            row.getFileLink().click();
            return (FileSourcePage)this.pageBinder.bind(FileSourcePage.class, new Object[]{this.projectKey, this.slug, path, this.revisionSpecifier});
        }
        throw new NoSuchElementException(String.format("No file with name [%s] in current file list", filePath));
    }

    public void openFocusedFile(String fileName, String key) {
        if (key.equals("o")) {
            this.useShortcut(key);
        } else {
            this.useShortcut((CharSequence)Keys.RETURN);
        }
        Poller.waitUntil((TimedQuery)this.elementFinder.find(By.className((String)"stub")).timed().getText(), (Matcher)Matchers.equalTo((Object)fileName), (Poller.WaitTimeout)Poller.by((long)this.timeouts.timeoutFor(TimeoutType.PAGE_LOAD)));
    }

    public String getCurrentFileName() {
        return this.driver.findElement(By.className((String)"stub")).getText();
    }

    public String getFocusedFileName() {
        return this.fileTable.getFocusedRow().getFileName();
    }

    public LabelList getLabelList() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.id((String)"label-list-container")).timed().isVisible());
        return (LabelList)this.pageBinder.bind(LabelList.class, new Object[0]);
    }

    public void findFiles(String value) {
        final String resultSetId = this.fileTable.getAttribute("data-result-set-id");
        this.getFileFinder().setFilter(value);
        Poller.waitUntilTrue((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                try {
                    return !FileBrowserPage.this.fileTable.hasAttribute("data-result-set-id", resultSetId);
                }
                catch (StaleElementReferenceException e) {
                    return false;
                }
            }
        }));
    }

    public CloneRepo getCloneRepo() {
        return this.cloneRepo;
    }

    @Override
    public String getUrl() {
        String url = super.getUrl();
        if (this.line != null) {
            url = url + '#' + this.line;
        }
        return url;
    }

    private FileFinder getFileFinder() {
        return (FileFinder)this.pageBinder.bind(FileFinder.class, new Object[0]);
    }

    public PageElement getWatchRepositoryFeatureDiscoveryDialog() {
        PageElement dialog = this.elementFinder.find(By.id((String)"feature-discovery-watch-repository_watch-repository"));
        Poller.waitUntilTrue((TimedQuery)dialog.timed().isVisible());
        return dialog;
    }

    public static class CloneRepo
    extends LegacyElementPageObject {
        static final String ID = "repository-protocol-selector";
        static final String HTTP_CLONE_ID = "http-clone-url";
        @Inject
        protected PageElementFinder globalFinder;

        public CloneRepo(@Nonnull PageElement element) {
            super(element);
        }

        public CloneRepo(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public String getHttpCloneUrl() {
            return this.findCloneMethodElement(HTTP_CLONE_ID).getAttribute("data-clone-url");
        }

        public boolean isMultipleCloneMethods() {
            return this.isPresent();
        }

        protected PageElement findCloneMethodElement(String cloneElementId) {
            if (this.isMultipleCloneMethods()) {
                return this.find(By.id((String)cloneElementId));
            }
            return this.globalFinder.find(By.id((String)cloneElementId));
        }
    }
}

