/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.hooks;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.hooks.RepositoryHookRow;
import com.atlassian.webdriver.bitbucket.page.admin.hooks.RepositoryHooksPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class RepositoryHookProjectRow
extends RepositoryHookRow {
    public RepositoryHookProjectRow(@Nonnull PageElement row, @Nonnull RepositoryHooksPage parent) {
        super(row, parent);
    }

    @Override
    public RepositoryHookRow bind() {
        return (RepositoryHookRow)this.pageBinder.bind(RepositoryHookProjectRow.class, new Object[]{this.container, this.parent});
    }

    @Override
    public TimedQuery<RepositoryHookRow.RepositoryChangesState> getRepositoryChangesState() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> RepositoryHookRow.RepositoryChangesState.isAllowed(this.getHookCustomizableCell().getText().equals("Allowed") && !this.getHookCustomizableCell().find(By.cssSelector((String)".locked-icon")).isPresent()));
    }

    @Override
    public TimedQuery<RepositoryHookRow.HookState> getState() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> RepositoryHookRow.HookState.getHookState(this.getHookStatusCell().find(By.tagName((String)"span")).getText().equals("DISABLED")));
    }

    @Nonnull
    public RepositoryHookRow setRestrictionState(boolean restrictHook) {
        ElementUtils.scrollIntoView(this.container.find(By.cssSelector((String)".hook-toggle-cell .aui-button")));
        this.container.find(By.cssSelector((String)".hook-toggle-cell .aui-button")).click();
        if (restrictHook) {
            this.container.find(By.cssSelector((String)"[data-testid='add-restriction']")).click();
        } else {
            this.container.find(By.cssSelector((String)"[data-testid='remove-restriction']")).click();
        }
        if (restrictHook) {
            this.parent.clickSaveWithNewRestriction();
        }
        Poller.waitUntilFalse((TimedQuery)this.loadingIndicator.timed().isVisible());
        return this.bind();
    }

    public boolean checkHookCanBeRestricted() {
        ElementUtils.scrollIntoView(this.container.find(By.cssSelector((String)".hook-toggle-cell .aui-button")));
        this.container.find(By.cssSelector((String)".hook-toggle-cell .aui-button")).click();
        return this.container.find(By.cssSelector((String)"[data-testid^='hooks-restriction-toggle']")).isPresent();
    }

    public TimedQuery<Boolean> verifyRepositoryChangesDisabled() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> {
            ElementUtils.scrollIntoView(this.container.find(By.cssSelector((String)".hook-toggle-cell .aui-button")));
            this.container.find(By.cssSelector((String)".hook-toggle-cell .aui-button")).click();
            int disabledCount = this.container.findAll(By.cssSelector((String)"[data-testid^='hooks-restriction-toggle'] .aui-dropdown2-disabled")).size();
            this.container.find(By.cssSelector((String)".hook-toggle-cell .aui-button")).click();
            return disabledCount == 2;
        });
    }
}

