/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element.admin.ratelimit;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.TimedElement;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.admin.ratelimit.ManageUserExemptionDialog;
import com.atlassian.webdriver.bitbucket.element.admin.ratelimit.RateLimitHistoryTable;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.TimedUtils;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class RateLimitHistoryEntry
extends AbstractElementPageObject {
    private final PageElement actionsButton;
    private final PageBinder binder;
    private final PageElementFinder finder;
    private final RateLimitHistoryTable historyTable;
    private final TimedElement rejectCount;
    private final TimedElement timestamp;
    private final TimedElement username;

    public RateLimitHistoryEntry(@Nonnull PageElement container, PageBinder binder, PageElementFinder finder, RateLimitHistoryTable table) {
        super(container);
        this.rejectCount = container.find(By.cssSelector((String)"td.reject-count")).timed();
        this.username = container.find(By.cssSelector((String)"td.user-name")).timed();
        this.timestamp = container.find(By.cssSelector((String)"td.last-limited > time")).timed();
        this.actionsButton = container.find(By.cssSelector((String)"td.actions > button"));
        this.binder = binder;
        this.finder = finder;
        this.historyTable = table;
    }

    public TimedQuery<Integer> getCurrentRejectCount() {
        return TimedUtils.toMappable(this.rejectCount.getText()).map(Integer::parseInt);
    }

    public TimedQuery<String> getTimestamp() {
        return this.timestamp.getAttribute("datetime");
    }

    public TimedQuery<Integer> getUpdatedRejectCount() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> {
            this.historyTable.refreshEntries();
            return (Integer)this.getCurrentRejectCount().byDefaultTimeout();
        });
    }

    public TimedQuery<String> getUsername() {
        return this.username.getText();
    }

    public ManageUserExemptionDialog manageExemptions() {
        this.actionsButton.click();
        PageElement actionsMenu = this.find(By.cssSelector((String)"[role='menu']"));
        RateLimitHistoryActionsMenu menu = ElementUtils.bind(this.binder, RateLimitHistoryActionsMenu.class, this.binder, this.finder).apply(actionsMenu);
        return menu.manageExemptions();
    }

    public static class RateLimitHistoryActionsMenu
    extends AbstractElementPageObject {
        private final PageBinder binder;
        private final PageElementFinder finder;
        private final PageElement manageExemptionsAction;

        public RateLimitHistoryActionsMenu(@Nonnull PageElement container, PageBinder binder, PageElementFinder finder) {
            super(container);
            this.manageExemptionsAction = container.find(By.cssSelector((String)"[role='menuitem']"));
            this.binder = binder;
            this.finder = finder;
        }

        public TimedCondition isVisible() {
            return this.container.timed().isVisible();
        }

        public ManageUserExemptionDialog manageExemptions() {
            this.manageExemptionsAction.click();
            return (ManageUserExemptionDialog)this.binder.bind(ManageUserExemptionDialog.class, new Object[]{this.finder});
        }
    }
}

