/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AuiForm;
import com.atlassian.webdriver.bitbucket.element.CloneDialog;
import com.atlassian.webdriver.bitbucket.element.ProjectSidebarNav;
import com.atlassian.webdriver.bitbucket.element.RepositoryShortcut;
import com.atlassian.webdriver.bitbucket.element.RepositoryShortcutAddForm;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import com.atlassian.webdriver.bitbucket.page.CommitListPage;
import com.atlassian.webdriver.bitbucket.page.FileBrowserPage;
import com.atlassian.webdriver.bitbucket.page.RepositoryEditSettingsPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import org.openqa.selenium.By;

public abstract class BaseRepositoryPage
extends BaseSidebarPage {
    protected final String projectKey;
    protected final String slug;
    @ElementBy(cssSelector="#content > .aui-sidebar .aui-navgroup-vertical", pageElementClass=ProjectSidebarNav.class)
    private ProjectSidebarNav items;

    public BaseRepositoryPage(String projectKey, String slug) {
        this.projectKey = projectKey;
        this.slug = slug;
    }

    @Override
    public void doWait() {
        super.doWait();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"footer-body")).timed().isPresent());
    }

    public ProjectSidebarNav getItems() {
        return this.items;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public List<RepositoryShortcut> getShortcuts() {
        if (this.getSidebar().isCollapsed()) {
            this.getSidebar().toggle();
        }
        return (List)this.body.findAll(By.cssSelector((String)"div#bitbucket\\.web\\.sidebar\\.repository\\.nav\\.shortcuts-heading + ul.aui-nav > li")).stream().map(ElementUtils.bind(this.pageBinder, RepositoryShortcut.class, new Object[0])).collect(MoreCollectors.toImmutableList());
    }

    public String getSlug() {
        return this.slug;
    }

    public CommitListPage goToCommitsPage() {
        this.items.clickCommitsItem();
        return (CommitListPage)this.pageBinder.bind(CommitListPage.class, new Object[]{this.projectKey, this.slug});
    }

    public RepositoryEditSettingsPage goToEditSettingsPage() {
        this.items.clickSettingsItem();
        return (RepositoryEditSettingsPage)this.pageBinder.bind(RepositoryEditSettingsPage.class, new Object[]{this.projectKey, this.slug});
    }

    public FileBrowserPage goToFilesPage() {
        this.items.clickRepositoriesItem();
        return (FileBrowserPage)this.pageBinder.bind(FileBrowserPage.class, new Object[]{this.projectKey, this.slug});
    }

    public RepositoryShortcutAddForm openAddShortcutForm() {
        PageElement dialog;
        if (this.getSidebar().isCollapsed()) {
            this.getSidebar().toggle();
        }
        if (!(dialog = this.elementFinder.find(By.cssSelector((String)"#add-shortcut-dialog"))).isPresent()) {
            this.content.find(By.id((String)"add-repo-shortcut-trigger")).click();
        }
        Poller.waitUntilTrue((TimedQuery)dialog.find(By.cssSelector((String)"form")).timed().isVisible());
        return (RepositoryShortcutAddForm)dialog.find(AuiForm.SELECTOR, RepositoryShortcutAddForm.class);
    }

    public CloneDialog openCloneDialog() {
        this.items.clickCloneItem();
        CloneDialog cloneDialog = (CloneDialog)this.pageBinder.bind(CloneDialog.class, new Object[]{this.elementFinder});
        Poller.waitUntilTrue((TimedQuery)cloneDialog.isOpen());
        return cloneDialog;
    }
}

