/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.Dialog;
import com.atlassian.webdriver.bitbucket.element.Dialog2;
import com.atlassian.webdriver.bitbucket.element.PullRequestMergeDiagram;
import com.atlassian.webdriver.bitbucket.page.AbstractPage;
import com.atlassian.webdriver.bitbucket.page.PullRequestPage;
import org.openqa.selenium.By;

public class PullRequestMergeConfirmDialog<T extends PullRequestPage>
extends Dialog2 {
    private final T page;
    @ElementBy(id="commit-message")
    private PageElement commitMessageTextarea;
    @ElementBy(id="delete-branch-checkbox")
    private PageElement deleteBranchCheckbox;
    @ElementBy(className="confirm-button")
    private PageElement mergeButton;
    @ElementBy(id="merge-strategy-button")
    private PageElement mergeStrategyDropDown;
    @ElementBy(cssSelector=".branch-diagram")
    private PageElement mergeDiagram;

    public PullRequestMergeConfirmDialog(By locatable, TimeoutType timeoutType, T page) {
        super(locatable, timeoutType);
        this.page = page;
    }

    public T confirmAndWaitForReload() {
        ((AbstractPage)this.page).waitForPageLoad(new Runnable(){

            @Override
            public void run() {
                PullRequestMergeConfirmDialog.this.mainActionButton.click();
            }
        });
        return this.page;
    }

    public T confirmMerge() {
        this.clickMainAction();
        return this.page;
    }

    public T confirmMergeExpectingWarning(By warningDialogLocator) {
        this.clickMainActionExpectingAnotherDialog();
        Dialog warningDialog = (Dialog)((Object)this.pageBinder.bind(Dialog.class, new Object[]{warningDialogLocator}));
        Poller.waitUntilTrue((TimedQuery)warningDialog.find(By.className((String)"aui-message-warning")).timed().isVisible());
        warningDialog.clickCancel();
        return this.page;
    }

    public PageElement getDeleteBranchCheckbox() {
        return this.deleteBranchCheckbox;
    }

    public PageElement getMergeButton() {
        return this.mergeButton;
    }

    public PageElement getMergeStrategyDropDown() {
        return this.mergeStrategyDropDown;
    }

    public PullRequestMergeDiagram getMergeDiagram() {
        return (PullRequestMergeDiagram)this.pageBinder.bind(PullRequestMergeDiagram.class, new Object[]{this.mergeDiagram});
    }

    public PullRequestMergeConfirmDialog<T> setCommitMessage(String msg) {
        this.commitMessageTextarea.type(new CharSequence[]{msg});
        return this;
    }
}

