/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.CommentForm;
import com.atlassian.webdriver.bitbucket.element.Dialog;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.LikesInfoDialog;
import com.atlassian.webdriver.bitbucket.element.tasks.Task;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.integration.jira.element.JiraCreateIssueDialog;
import com.atlassian.webdriver.integration.jira.element.JiraIssueList;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.List;
import org.openqa.selenium.By;

public class Comment
extends LegacyElementPageObject {
    public static final String COMMENT_CLASS = "comment";
    private long id = -1L;
    private int version = -1;

    public Comment(PageElement pageElement) {
        super(pageElement);
    }

    public Comment(By locator) {
        super(locator);
    }

    public Comment(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public Comment(WebDriverLocatable locatable, TimeoutType timeoutType) {
        super(locatable, timeoutType);
    }

    public Comment(By locator, WebDriverLocatable parent, TimeoutType timeoutType) {
        super(locator, parent, timeoutType);
    }

    public Comment(By locator, WebDriverLocatable parent) {
        super(locator, parent);
    }

    public String getAuthor() {
        return this.find(By.cssSelector((String)".content .user-name")).getText();
    }

    public String getCommentText() {
        return this.findCommentText().getText();
    }

    public String getCommentHtml() {
        return ElementUtils.getHtml(this.findCommentText());
    }

    public long getCommentId() {
        if (this.id == -1L) {
            this.id = Long.parseLong(this.getAttribute("data-id"));
        }
        return this.id;
    }

    public int getCommentVersion() {
        if (this.version == -1) {
            this.version = Integer.parseInt(this.getAttribute("data-version"));
        }
        return this.version;
    }

    public ReplyCommentForm reply() {
        this.find(By.className((String)"reply")).click();
        return this.getReplyCommentForm();
    }

    public Comment replyWith(String text) {
        ReplyCommentForm replyForm = this.reply();
        replyForm.setText(text);
        return replyForm.submit();
    }

    public ReplyCommentForm getReplyCommentForm() {
        return (ReplyCommentForm)this.find(By.cssSelector((String)".replies .comment-form-container"), ReplyCommentForm.class, this.defaultTimeout);
    }

    public EditCommentForm edit() {
        this.find(By.cssSelector((String)".actions .edit")).click();
        return this.getEditForm();
    }

    public Comment toggleLike() {
        this.getLikeButton().click();
        return this;
    }

    protected PageElement getLikeButton() {
        return this.find(By.cssSelector((String)".info .comment-likes-button"));
    }

    protected PageElement getLikeDialogButton() {
        return this.find(By.cssSelector((String)".info .comment-likes-info button"));
    }

    public boolean hasLikeButton() {
        return this.getLikeButton().getText().equals("Like");
    }

    public TimedCondition canLike() {
        return this.getLikeButton().timed().isPresent();
    }

    public String getLikeInfo() {
        return this.find(By.cssSelector((String)".info .comment-likes-info")).getText();
    }

    public TimedCondition isLikeDialogAvailable() {
        return this.getLikeDialogButton().timed().isPresent();
    }

    public LikesInfoDialog openLikeDialog() {
        this.getLikeDialogButton().click();
        LikesInfoDialog dialog = (LikesInfoDialog)this.pageBinder.bind(LikesInfoDialog.class, new Object[]{By.id((String)"inline-dialog-likes-info-panel")});
        Poller.waitUntilTrue((TimedQuery)dialog.isOpen());
        return dialog;
    }

    public EditCommentForm getEditForm() {
        return (EditCommentForm)this.find(this.locatable.getLocator(), EditCommentForm.class, this.defaultTimeout);
    }

    public DeleteCommentDialog delete() {
        final PageElement deleteLink = this.find(By.cssSelector((String)".actions .delete"));
        deleteLink.click();
        return (DeleteCommentDialog)((Object)this.pageBinder.bind(DeleteCommentDialog.class, new Object[]{By.id((String)"delete-repository-dialog"), new Supplier<Void>(){

            public Void get() {
                Poller.waitUntilFalse((TimedQuery)deleteLink.timed().isVisible());
                return null;
            }
        }}));
    }

    public List<Comment> getReplies() {
        return this.findAll(By.cssSelector((String)".replies > li"), Comment.class);
    }

    public boolean hasReplies() {
        return this.find(By.className((String)".replies")).isPresent();
    }

    private PageElement findCommentText() {
        return this.find(By.cssSelector((String)".content .message"));
    }

    public Task createTask(String text) {
        this.openTaskForm().setTaskText(text).save();
        Task newTask = this.getTaskAt(0);
        return this.getTaskById(newTask.getTaskId());
    }

    public Task getTaskAt(int index) {
        List<Task> tasks = this.getTasks();
        return tasks.get(index);
    }

    public Task getTaskById(long id) {
        return (Task)this.find(By.cssSelector((String)(".task[data-task-id='" + id + "']")), Task.class);
    }

    public int getTaskCount() {
        return this.getTasks().size();
    }

    protected List<Task> getTasks() {
        return this.findAll(By.cssSelector((String)".content > .extras > .task-list .task"), Task.class);
    }

    public Task openTaskForm() {
        this.find(By.className((String)"task-create")).click();
        return (Task)this.find(By.cssSelector((String)".task[data-task-id='']"), Task.class);
    }

    public JiraCreateIssueDialog openCreateJiraIssueDialog() {
        this.find(By.className((String)"issue-create")).click();
        return (JiraCreateIssueDialog)this.pageBinder.bind(JiraCreateIssueDialog.class, new Object[0]);
    }

    public JiraIssueList getCommentJiraIssueList() {
        PageElement issueList = this.find(By.className((String)"jira-issue-list-container"));
        return (JiraIssueList)this.pageBinder.bind(JiraIssueList.class, new Object[]{issueList});
    }

    public static class ReplyCommentForm
    extends CommentForm<ReplyCommentForm> {
        public ReplyCommentForm(By locator, WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        @Override
        public Comment submit() {
            int count = this.getComments().size();
            this.getCommentButton().click();
            Poller.waitUntilTrue((TimedQuery)this.moreCommentsThan(count));
            return (Comment)((Object)Iterables.getLast(this.getComments()));
        }

        private List<Comment> getComments() {
            return this.findAll(By.className((String)Comment.COMMENT_CLASS), Comment.class);
        }

        private TimedCondition moreCommentsThan(final int before) {
            return Conditions.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Boolean>(){

                public Boolean get() {
                    return before < this.getComments().size();
                }
            });
        }
    }

    public static class EditCommentForm
    extends CommentForm<EditCommentForm> {
        public EditCommentForm(By locator, WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        @Override
        public void cancel() {
            super.cancel();
            Poller.waitUntilFalse((TimedQuery)this.getCancelLink().timed().isPresent());
        }

        @Override
        public Comment submit() {
            this.getCommentButton().click();
            Poller.waitUntilFalse((TimedQuery)this.getCommentButton().timed().isPresent());
            return (Comment)((Object)this.pageBinder.bind(Comment.class, new Object[]{this.locatable, this.defaultTimeout}));
        }
    }

    public static class DeleteCommentDialog
    extends Dialog {
        private final Supplier<Void> after;

        public DeleteCommentDialog(By locator, Supplier<Void> after) {
            super(locator);
            this.after = after;
        }

        public void confirmDelete() {
            super.clickMainAction();
            this.after.get();
        }
    }
}

