/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.bitbucket.test.BuildStatusTestHelper;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.Dialog;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.By;

public class BuildStatusDialog
extends Dialog {
    public BuildStatusDialog(By locator) {
        super(locator);
    }

    public BuildStatusDialog(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public BuildStatusDialog(WebDriverLocatable locatable, TimeoutType timeoutType) {
        super(locatable, timeoutType);
    }

    public Optional<BuildStatusLine> getBuildStatusForKey(String key) {
        return this.getBuildStatusLines().stream().filter(bs -> key.equals(bs.getBuildKey())).findAny();
    }

    public List<BuildStatusLine> getBuildStatusLines() {
        PageElement buildStatusList = this.find(By.className((String)"build-status-list"));
        Poller.waitUntilTrue((TimedQuery)buildStatusList.timed().isVisible());
        return Lists.newArrayList((Iterable)Lists.transform((List)buildStatusList.findAll(By.tagName((String)"li")), element -> (BuildStatusLine)this.pageBinder.bind(BuildStatusLine.class, new Object[]{element})));
    }

    public static class BuildStatusLine {
        private final PageElement element;

        public BuildStatusLine(PageElement element) {
            this.element = element;
        }

        public String getBuildKey() {
            return this.element.find(By.className((String)"summary")).getAttribute("data-key");
        }

        public BuildStatusTestHelper.State getStatus() {
            PageElement icon = this.element.find(By.className((String)"build-icon"));
            if (!icon.isPresent()) {
                return null;
            }
            if (icon.hasClass("successful-build-icon")) {
                return BuildStatusTestHelper.State.SUCCESSFUL;
            }
            if (icon.hasClass("failed-build-icon")) {
                return BuildStatusTestHelper.State.FAILED;
            }
            if (icon.hasClass("inprogress-build-icon")) {
                return BuildStatusTestHelper.State.INPROGRESS;
            }
            return null;
        }
    }
}

