/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repo;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.admin.repo.RepositoryHookDialog;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class RepositoryHooksPage
extends BaseRepositoryPage {
    public RepositoryHooksPage(String projectKey, String repositorySlug) {
        super(projectKey, repositorySlug);
    }

    public String getUrl() {
        return String.format("/projects/%s/repos/%s/settings/hooks", this.projectKey, this.slug);
    }

    private void showActions() {
        this.javascriptExecutor.executeScript("jQuery('.edit-button').css('visibility', 'visible');", new Object[0]);
    }

    public List<HookRow> getPreReceiveHookRows() {
        return this.getHooks(By.cssSelector((String)"#pre-receive-hook-table tbody tr"));
    }

    public List<HookRow> getPostReceiveHookRows() {
        return this.getHooks(By.cssSelector((String)"#post-receive-hook-table tbody tr"));
    }

    private List<HookRow> getHooks(By selector) {
        return Lists.newArrayList((Iterable)Lists.transform((List)this.elementFinder.findAll(selector), (Function)new Function<PageElement, HookRow>(){

            public HookRow apply(PageElement row) {
                return (HookRow)RepositoryHooksPage.this.pageBinder.bind(HookRow.class, new Object[]{row, RepositoryHooksPage.this});
            }
        }));
    }

    public void loadNextPreReceivePage() {
        this.elementFinder.find(By.cssSelector((String)"#pre-receive-hook-table tfoot tr td .load-more")).click();
        Poller.waitUntilFalse((TimedQuery)this.elementFinder.find(By.cssSelector((String)".spinner div")).timed().isVisible());
    }

    public static class HookRow
    extends AbstractElementPageObject {
        private final RepositoryHooksPage parent;

        public HookRow(@Nonnull PageElement row, @Nonnull RepositoryHooksPage parent) {
            super(row);
            this.parent = (RepositoryHooksPage)Preconditions.checkNotNull((Object)parent, (Object)"parent");
        }

        public String getName() {
            return this.find(By.className((String)"hook-name")).getText();
        }

        public String getDescription() {
            return this.find(By.className((String)"hook-description")).getText();
        }

        public boolean hasEmptyDescription() {
            return this.find(By.cssSelector((String)".hook-description .empty-description")).isPresent();
        }

        public boolean isEnabled() {
            return Boolean.valueOf(this.find(By.className((String)"mode-enabled")).getAttribute("aria-pressed"));
        }

        public void enable() {
            this.find(By.className((String)"mode-enabled")).click();
        }

        public void disable() {
            this.find(By.className((String)"mode-disabled")).click();
        }

        public RepositoryHookDialog configure() {
            this.parent.showActions();
            this.find(By.className((String)"edit-button")).click();
            return (RepositoryHookDialog)this.pageBinder.bind(RepositoryHookDialog.class, new Object[]{this.parent.projectKey, this.parent.slug});
        }
    }
}

