/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.UserProfileRepositoriesTabPage;
import java.io.UnsupportedEncodingException;
import java.text.Normalizer;
import org.openqa.selenium.By;
import org.springframework.web.util.UriUtils;

public class UserProfilePage
extends BitbucketPage {
    private String slug;

    public UserProfilePage(String slug) {
        this.slug = slug;
    }

    public String getUrl() {
        return "/users/" + this.encodedSlug();
    }

    private String encodedSlug() {
        try {
            String encoded = UriUtils.encodePathSegment((String)this.slugify(this.slug), (String)"UTF-8");
            encoded = encoded.replace("'", "%27");
            return encoded;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private String slugify(String username) {
        String slug = IdentifierUtils.toLowerCase((String)username);
        slug = Normalizer.normalize(slug, Normalizer.Form.NFKD);
        slug = slug.replace("/", "%2f").replace("\\", "%5c");
        return slug;
    }

    public String getDisplayName() {
        return this.driver.findElement(By.cssSelector((String)"header .entity-name")).getText();
    }

    public String getUsername() {
        return this.driver.findElement(By.cssSelector((String)"header .user-detail.username")).getText();
    }

    public String getEmail() {
        return this.driver.findElement(By.cssSelector((String)"header .user-detail.email")).getText();
    }

    public UserProfileRepositoriesTabPage clickRepositoriesTab() {
        this.driver.findElement(By.id((String)"repositories-tab")).click();
        return (UserProfileRepositoriesTabPage)this.pageBinder.bind(UserProfileRepositoriesTabPage.class, new Object[]{this.slug});
    }

    public UserProfileRepositoriesTabPage showRepositoriesTab() {
        if (this.driver.findElements(By.className((String)"menu-item")).size() == 0) {
            return (UserProfileRepositoriesTabPage)this.pageBinder.bind(UserProfileRepositoriesTabPage.class, new Object[]{this.slug});
        }
        return this.clickRepositoriesTab();
    }
}

