/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.Comment;
import com.atlassian.webdriver.bitbucket.element.DiffCommentForm;
import com.atlassian.webdriver.bitbucket.element.DiffFileContent;
import com.atlassian.webdriver.bitbucket.element.FileTree;
import com.atlassian.webdriver.bitbucket.element.UnifiedDiffFileContent;
import com.atlassian.webdriver.bitbucket.page.PullRequestPage;
import org.openqa.selenium.By;

public class PullRequestDiffPage
extends PullRequestPage<PullRequestDiffPage> {
    @ElementBy(cssSelector=".file-content", pageElementClass=UnifiedDiffFileContent.class)
    protected UnifiedDiffFileContent fileContent;
    @ElementBy(className="file-tree-container", pageElementClass=FileTree.class)
    private FileTree tree;
    private final String projectKey;
    private final String slug;
    private final long pullRequestId;
    private final String path;

    public PullRequestDiffPage(String projectKey, String slug, long pullRequestId) {
        this(projectKey, slug, pullRequestId, null);
    }

    public PullRequestDiffPage(String projectKey, String slug, long pullRequestId, String path) {
        super(projectKey, slug, pullRequestId);
        this.projectKey = projectKey;
        this.slug = slug;
        this.pullRequestId = pullRequestId;
        this.path = path;
    }

    public PullRequestDiffPage addComment(DiffFileContent.Line line, String comment) {
        DiffCommentForm element = this.openNewComment(line, comment);
        element.submit();
        return (PullRequestDiffPage)this.pageBinder.bind(PullRequestDiffPage.class, new Object[]{this.projectKey, this.slug, this.pullRequestId});
    }

    public DiffCommentForm openNewComment(DiffFileContent.Line line, String comment) {
        line.getAddComment().click();
        DiffCommentForm element = (DiffCommentForm)this.tree.find(By.className((String)"new-comment-form"), DiffCommentForm.class, TimeoutType.COMPONENT_LOAD);
        element.setText(comment);
        return element;
    }

    public <T extends Comment> T addComment(Class<T> clazz, DiffFileContent.Line line, String comment) {
        DiffCommentForm element = this.openNewComment(line, comment);
        Comment commentElement = element.submit();
        return (T)((Object)((Comment)((Object)this.pageBinder.bind(clazz, new Object[]{By.cssSelector((String)(".comment[data-id=\"" + commentElement.getId() + "\"]"))}))));
    }

    public Comment getCommentAt(int index) {
        return this.getFileContent().getComments().get(index);
    }

    @Override
    @WaitUntil
    public void waitUntilPageLoaded() {
        this.waitUntilDiffTreeLoaded();
        this.waitUntilFileContentLoaded();
    }

    private void waitUntilDiffTreeLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)".file-tree ul"), TimeoutType.PAGE_LOAD).timed().isPresent());
    }

    private void waitUntilFileContentLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)"#commit-file-content .fully-loaded,#commit-file-content .message-content,#commit-file-content .binary-container"), TimeoutType.PAGE_LOAD).timed().isPresent());
    }

    public PullRequestDiffPage clickFileAndWaitUntilLoaded(String path) {
        this.waitUntilDiffTreeLoaded();
        this.tree.find(By.cssSelector((String)("[href=\"#" + path + "\"]"))).click();
        this.waitUntilFileContentLoaded();
        return (PullRequestDiffPage)this.pageBinder.bind(PullRequestDiffPage.class, new Object[]{this.projectKey, this.slug, this.pullRequestId, path});
    }

    @Override
    public String getUrl() {
        String url = super.getUrl() + "/diff";
        if (this.path != null) {
            url = url + "#" + this.path;
        }
        return url;
    }

    public FileTree getFileTree() {
        return this.tree;
    }

    public UnifiedDiffFileContent getFileContent() {
        return this.fileContent;
    }
}

