/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AuiMessage;
import com.atlassian.webdriver.bitbucket.element.ProjectTable;
import com.atlassian.webdriver.bitbucket.page.BitbucketPage;
import com.atlassian.webdriver.bitbucket.page.ProjectCreatePage;
import java.util.List;
import org.openqa.selenium.By;

public class ProjectListPage
extends BitbucketPage {
    @ElementBy(className="create-project-link")
    private PageElement createProjectLink;
    @ElementBy(id="projects-table", pageElementClass=ProjectTable.class)
    private ProjectTable projectTable;

    public String getUrl() {
        return "/projects";
    }

    public boolean canCreateProject() {
        return this.createProjectLink.isPresent();
    }

    public ProjectCreatePage goToCreateProjectPage() {
        this.createProjectLink.click();
        return (ProjectCreatePage)this.pageBinder.bind(ProjectCreatePage.class, new Object[0]);
    }

    public ProjectTable getProjectTable() {
        return this.projectTable;
    }

    public ProjectTable.ProjectRow findProjectByName(String projectName) {
        return this.projectTable.findProjectByName(projectName);
    }

    public List<AuiMessage> getMessages() {
        return this.body.findAll(By.className((String)"aui-message"), AuiMessage.class);
    }

    @Override
    public void doWait() {
        super.doWait();
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"footer-body")).timed().isPresent());
    }
}

