/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.DiffFileContent;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.openqa.selenium.By;

public class SideBySideDiffFileContent
extends DiffFileContent {
    public SideBySideDiffFileContent(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    @Override
    public void waitUntilFileContentLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.getContentView().timed().hasClass("side-by-side-diff"));
        super.waitUntilFileContentLoaded();
    }

    private List<Line> getLines(final String fileType) {
        return this.waitForSourceContainer(new Supplier<List<Line>>(){

            public List<Line> get() {
                return SideBySideDiffFileContent.this.findAll(By.cssSelector((String)(".side-by-side-diff-editor-" + fileType + " .line")), Line.class);
            }
        });
    }

    public List<Line> getFromLines() {
        return this.getLines("from");
    }

    public List<Line> getToLines() {
        return this.getLines("to");
    }

    public Lineset getLines(int fromStart, int fromEnd, int toStart, int toEnd) {
        return new Lineset(this, fromStart, fromEnd, toStart, toEnd);
    }

    public static class Lineset {
        private SideBySideDiffFileContent fileContent;
        private int fromStart;
        private int fromEnd;
        private int toStart;
        private int toEnd;

        private Lineset(SideBySideDiffFileContent fileContent, int fromStart, int fromEnd, int toStart, int toEnd) {
            this.fileContent = fileContent;
            this.fromStart = fromStart;
            this.fromEnd = fromEnd;
            this.toStart = toStart;
            this.toEnd = toEnd;
        }

        public void assertHasFocus() {
            if (!Lineset.hasFocus(this.fileContent, "from", this.fromStart, this.fromEnd) || !Lineset.hasFocus(this.fileContent, "to", this.toStart, this.toEnd)) {
                String fromRange = this.fromStart > -1 ? this.fromStart + "," + this.fromEnd : ",";
                String toRange = this.toStart > -1 ? this.toStart + "," + this.toEnd : ",";
                try {
                    String extraFromFocus = StringUtils.join(Lineset.getExtraFocus(this.fileContent, "from", this.fromStart, this.fromEnd), (String)",");
                    String extraToFocus = StringUtils.join(Lineset.getExtraFocus(this.fileContent, "to", this.toStart, this.toEnd), (String)",");
                    String missingFromFocus = this.fromStart > -1 ? StringUtils.join(Lineset.getMissingFocus(this.fileContent, "from", this.fromStart, this.fromEnd), (String)",") : "";
                    String missingToFocus = this.toStart > -1 ? StringUtils.join(Lineset.getMissingFocus(this.fileContent, "to", this.toStart, this.toEnd), (String)",") : "";
                    Assert.fail((String)("Lineset FROM[" + fromRange + "]:TO[" + toRange + "] has focus. " + "Extra focus: FROM(" + extraFromFocus + "):TO(" + extraToFocus + "); " + "Missing focus: FROM(" + missingFromFocus + "):TO(" + missingToFocus + ")"));
                }
                catch (Exception e) {
                    Assert.fail((String)("Lineset FROM[" + fromRange + "]:TO[" + toRange + "] has focus. " + "Actual from count: " + this.fileContent.findAll(By.cssSelector((String)".side-by-side-diff-editor-from .last-focus")).size() + " " + "Actual to count: " + this.fileContent.findAll(By.cssSelector((String)".side-by-side-diff-editor-to .last-focus")).size() + " "));
                }
            }
        }

        private static Iterable<Integer> getExtraFocus(SideBySideDiffFileContent fileContent, String side, final int start, final int end) {
            return Iterables.filter(Lineset.getFocusedLineNumbers(fileContent, side), (Predicate)new Predicate<Integer>(){

                public boolean apply(Integer input) {
                    return input < start || input > end;
                }
            });
        }

        private static Iterable<Integer> getFocusedLineNumbers(SideBySideDiffFileContent fileContent, String side) {
            List all = fileContent.findAll(By.cssSelector((String)(".side-by-side-diff-editor-" + side + " .last-focus")), Line.class);
            return Iterables.transform((Iterable)all, (Function)new Function<Line, Integer>(){

                public Integer apply(Line input) {
                    return input.getLine();
                }
            });
        }

        private static Iterable<Integer> getMissingFocus(SideBySideDiffFileContent fileContent, String side, int start, int end) {
            HashSet actualFocusedNumbers = Sets.newHashSet(Lineset.getFocusedLineNumbers(fileContent, side));
            ContiguousSet expectedFocusedNumbers = ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)), (DiscreteDomain)DiscreteDomain.integers());
            Iterables.removeAll((Iterable)expectedFocusedNumbers, (Collection)actualFocusedNumbers);
            return expectedFocusedNumbers;
        }

        private static boolean hasFocus(SideBySideDiffFileContent fileContent, final String side, int start, int end) {
            String selector;
            int matchingLines;
            int expectedFocus = start > -1 ? 1 + end - start : 0;
            int focused = fileContent.findAll(By.cssSelector((String)(".side-by-side-diff-editor-" + side + " .last-focus"))).size();
            if (focused != expectedFocus) {
                return false;
            }
            return start <= -1 || (matchingLines = fileContent.findAll(By.cssSelector((String)(selector = StringUtils.join((Iterable)Iterables.transform((Iterable)ContiguousSet.create((Range)Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end)), (DiscreteDomain)DiscreteDomain.integers()), (Function)new Function<Integer, String>(){

                public String apply(Integer i) {
                    return ".side-by-side-diff-editor-" + side + " .last-focus .line-number-marker[data-line-number=\"" + i + "\"]";
                }
            }), (char)',')))).size()) == expectedFocus;
        }
    }

    public static class Line
    extends DiffFileContent.Line {
        public Line(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public Line(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        public String getFileType() {
            return this.find(By.className((String)"line-number-marker")).getAttribute("data-file-type");
        }
    }
}

