/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.InfiniteScrollDialog;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import java.util.List;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public class RevisionHistoryDialog
extends InfiniteScrollDialog<Revision> {
    private static final String TRIGGER_CLASS = "until-commit-button";
    private static final String DIALOG_ID = "inline-dialog-until-commit";

    public RevisionHistoryDialog() {
        super(By.className((String)TRIGGER_CLASS), By.id((String)DIALOG_ID));
    }

    @Override
    protected Revision findItem(String s) {
        for (Revision revision : this.getItems()) {
            if (!revision.getRevisionId().equals(s)) continue;
            return revision;
        }
        throw new RuntimeException("Could not find revision with id " + s);
    }

    @Override
    public List<Revision> getItems() {
        return this.findAll(By.cssSelector((String)"li.commit-list-item"), Revision.class);
    }

    @Override
    public void loadNextPage() {
        this.javascript().execute("var $fileHist = jQuery(\"#inline-dialog-until-commit .file-history\");\n$fileHist.scrollTop($fileHist.children(\"ul\").height())", new Object[0]);
        this.waitUntilPageLoaded();
    }

    @Override
    public void waitUntilPageLoaded() {
        Poller.waitUntilFalse((TimedQuery)this.find(By.cssSelector((String)"#inline-dialog-until-commit .file-history .spinner > div")).timed().isPresent());
    }

    @Override
    public void clickItemAndWaitForClose(String itemName) {
        this.clickItem(itemName);
        Poller.waitUntilFalse((TimedQuery)this.timed().isVisible());
    }

    public static class Revision
    extends LegacyElementPageObject {
        public Revision(@Nonnull PageElement pageElement) {
            super(pageElement);
        }

        public Revision(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public Revision(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        public String getRevisionId() {
            return this.find(By.className((String)"commitid")).getText();
        }
    }
}

