/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.LinkElement;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.Locators;
import com.google.common.base.Preconditions;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.openqa.selenium.By;

public abstract class RepositoryTable<R extends RepositoryRow>
extends LegacyElementPageObject {
    private final Class<R> rowClass;

    protected RepositoryTable(@Nonnull PageElement pageElement, @Nonnull Class<R> rowClass) {
        super(pageElement);
        this.rowClass = (Class)Preconditions.checkNotNull(rowClass, (Object)"rowClass");
    }

    public RepositoryTable(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
        this.rowClass = (Class)((ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public R scrollToRepository(String repositoryName) {
        for (int i = 0; i < 20; ++i) {
            R repository = this.findRepositoryByName(repositoryName);
            if (repository != null) {
                return repository;
            }
            this.loadNextPage();
        }
        throw new AssertionError((Object)("Could not find repository: " + repositoryName));
    }

    public R findRepositoryByName(String repositoryName) {
        for (RepositoryRow row : this.getRepositories()) {
            if (!row.getRepositoryName().equals(repositoryName)) continue;
            return (R)((Object)row);
        }
        return null;
    }

    public List<R> getRepositories() {
        return this.findAll(Locators.tableRow(), this.rowClass);
    }

    private void loadNextPage() {
        ElementUtils.waitUntilUpdated((PageElement)this, new Runnable(){

            @Override
            public void run() {
                ElementUtils.scrollDocument((PageElement)RepositoryTable.this);
            }
        });
    }

    public static class RepositoryRow
    extends LegacyElementPageObject {
        private static final Pattern REPO_SLUG = Pattern.compile("(?<=/repos/)([^/]+)");

        public RepositoryRow(@Nonnull PageElement pageElement) {
            super(pageElement);
        }

        public RepositoryRow(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public RepositoryRow(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        protected PageElement getNameColumn() {
            return (PageElement)this.findAll(By.tagName((String)"td")).get(0);
        }

        public String getRepositoryName() {
            return this.getRepositoryLink().getText();
        }

        public String getRepositorySlug() {
            String url = this.getRepositoryLink().getUrl();
            Matcher urlMatcher = REPO_SLUG.matcher(url);
            if (!urlMatcher.find()) {
                throw new RuntimeException("The repository URL format has changed. Please update the pattern.");
            }
            return urlMatcher.group();
        }

        protected LinkElement getRepositoryLink() {
            return (LinkElement)this.getNameColumn().find(By.tagName((String)"a"), LinkElement.class);
        }
    }
}

