/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.BaseRepositoryPage;
import com.atlassian.webdriver.bitbucket.page.PublicRepositoryListPage;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class RecentReposDropdown {
    @Inject
    protected PageBinder pageBinder;
    @Inject
    protected Timeouts timeouts;
    @ElementBy(id="com.atlassian.bitbucket.server.bitbucket-server-web-fragments-repositories-menu")
    protected PageElement container;
    @ElementBy(id="repositories-menu-trigger")
    protected PageElement trigger;

    @Nonnull
    public TimedQuery<Boolean> hasRecentRepositories() {
        return Conditions.not((TimedQuery)this.getNoRecentReposIndicator().timed().isPresent());
    }

    @Nonnull
    public TimedCondition isOpen() {
        return Conditions.and((TimedQuery[])new TimedQuery[]{this.container.timed().isVisible(), Conditions.not((TimedQuery)this.getLoadingRecentRepositoriesIndicator().timed().isVisible())});
    }

    @Nonnull
    public RecentReposDropdown open() {
        this.trigger.click();
        Poller.waitUntilTrue((TimedQuery)this.isOpen());
        return this;
    }

    @Nonnull
    public PublicRepositoryListPage openPublicRepositories() {
        Poller.waitUntilTrue((TimedQuery)this.isOpen());
        this.getPublicRepositoriesListSection().find(By.tagName((String)"a")).click();
        return (PublicRepositoryListPage)this.pageBinder.bind(PublicRepositoryListPage.class, new Object[0]);
    }

    @Nonnull
    public RecentReposDropdown toggle() {
        this.trigger.click();
        return this;
    }

    @Nonnull
    public TimedQuery<Iterable<RecentRepo>> getRecentRepositories() {
        return Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Iterable<RecentRepo>>(){

            public Iterable<RecentRepo> get() {
                return Chainable.chain((Iterable)RecentReposDropdown.this.getRecentRepositoriesSection().findAll(By.className((String)"repository-menu-item"))).transform(input -> (RecentRepo)RecentReposDropdown.this.pageBinder.bind(RecentRepo.class, new Object[]{input})).toList();
            }
        });
    }

    @Nonnull
    protected PageElement getLoadingRecentRepositoriesIndicator() {
        return this.getRecentRepositoriesSection().find(By.className((String)"loading-recent-repos"));
    }

    @Nonnull
    protected PageElement getNoRecentReposIndicator() {
        return this.getRecentRepositoriesSection().find(By.className((String)"no-recent-repos"));
    }

    @Nonnull
    protected PageElement getRecentRepositoriesSection() {
        return this.container.find(By.className((String)"recent-repositories-section"));
    }

    @Nonnull
    protected PageElement getPublicRepositoriesListSection() {
        return this.container.find(By.className((String)"public-repo-list-link-section"));
    }

    public static class RecentRepo {
        @Inject
        private PageBinder pageBinder;
        private final PageElement repoListItem;

        public RecentRepo(@Nonnull PageElement repoListItem) {
            this.repoListItem = (PageElement)Preconditions.checkNotNull((Object)repoListItem, (Object)"repoListItem");
        }

        @Nonnull
        public String getProjectKey() {
            return this.getRepoLink().getAttribute("data-proj-key");
        }

        @Nonnull
        public String getRepoSlug() {
            return this.getRepoLink().getAttribute("data-repo-slug");
        }

        @Nonnull
        public <RP extends BaseRepositoryPage> RP open(Class<RP> expectedRepositoryPage) {
            this.getRepoLink().click();
            return (RP)((BaseRepositoryPage)this.pageBinder.bind(expectedRepositoryPage, new Object[]{this.getProjectKey(), this.getRepoSlug()}));
        }

        private PageElement getRepoLink() {
            return this.repoListItem.find(By.tagName((String)"a"));
        }
    }
}

