/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.SearchableSelector;
import com.atlassian.webdriver.bitbucket.element.UserOption;
import com.atlassian.webdriver.bitbucket.element.UserSelect;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.base.Supplier;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class PullRequestDetails
extends LegacyElementPageObject {
    @Inject
    private PageElementFinder elementFinder;
    @ElementBy(id="title")
    private PageElement title;
    @ElementBy(id="pull-request-description")
    private PageElement description;
    @ElementBy(cssSelector=".pull-request-description .markup-preview-button")
    private PageElement previewButton;
    @ElementBy(cssSelector=".pull-request-description .markup-preview")
    private PageElement preview;

    public PullRequestDetails(PageElement pageElement) {
        super(pageElement);
    }

    public PullRequestDetails(By locatable, TimeoutType timeoutType) {
        super(locatable, timeoutType);
    }

    public PullRequestDetails(By locator, WebDriverLocatable parent, TimeoutType timeoutType) {
        super(locator, parent, timeoutType);
    }

    public PullRequestDetails setTitle(String title) {
        this.title.clear();
        this.title.type(new CharSequence[]{title});
        return this;
    }

    public String getTitle() {
        return this.title.getValue();
    }

    public TimedQuery<String> getTitleTimed() {
        return this.title.timed().getValue();
    }

    public PullRequestDetails setDescription(String description) {
        this.description.clear();
        this.description.type(new CharSequence[]{description});
        return this;
    }

    public String getDescription() {
        return this.description.getValue();
    }

    public SearchableSelector getToBranchSelector() {
        PageElement trigger = this.elementFinder.find(By.id((String)"toRef"));
        PageElement inputField = this.elementFinder.find(By.id((String)"toRef-field"));
        return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{trigger, By.id((String)"toRef-dialog"), inputField});
    }

    public PullRequestDetails togglePreview() {
        boolean visible = this.isPreviewVisible();
        this.previewButton.click();
        Poller.waitUntilEquals((Object)(!visible ? 1 : 0), (TimedQuery)this.preview.timed().isVisible());
        return this;
    }

    public boolean isPreviewVisible() {
        return this.preview.isVisible();
    }

    public String getPreviewHtml() {
        return ElementUtils.getHtml(this.preview);
    }

    public PullRequestDetails addReviewer(String username) {
        ((UserSelect)this.getReviewerSelect().type(username)).selectOption(username);
        return this;
    }

    @Nonnull
    public PullRequestDetails addReviewer(@Nonnull String searchTerm, @Nonnull String username) {
        ((UserSelect)this.getReviewerSelect().type(searchTerm)).selectOption(username);
        return this;
    }

    @Nonnull
    public PullRequestDetails removeReviewer(@Nonnull String username) {
        this.getReviewerSelect().removeOption(username);
        return this;
    }

    @Nonnull
    public TimedQuery<Iterable<String>> getReviewerUsernames() {
        return Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Iterable<String>>(){

            public Iterable<String> get() {
                return Chainable.chain((Iterable)((Iterable)PullRequestDetails.this.getReviewerSelect().getSelectedOptions().now())).transform(UserOption::getUsername).toList();
            }
        });
    }

    @Nonnull
    public UserSelect getReviewerSelect() {
        return (UserSelect)this.pageBinder.bind(UserSelect.class, new Object[]{this.find(By.cssSelector((String)".pull-request-reviewers .select2-container"))});
    }
}

