/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.IdOption;
import com.atlassian.webdriver.bitbucket.element.Select2;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class IdSelect2<S extends IdSelect2<S, O>, O extends IdOption>
extends Select2<S, O> {
    protected IdSelect2(@Nonnull PageElement container, @Nonnull Class<O> optionClass) {
        super(container, optionClass);
    }

    @Nonnull
    public TimedCondition hasOption(@Nonnull String id) {
        return this.hasOption(IdOption.idMatches(this.optionClass, id));
    }

    @Nonnull
    public TimedCondition hasSelectedOption(@Nonnull String id) {
        return this.hasSelectedOption(IdOption.idMatches(this.optionClass, id));
    }

    @Nullable
    public O findOption(@Nonnull String id) {
        return (O)((IdOption)this.findOption(IdOption.idMatches(this.optionClass, id)));
    }

    @Nullable
    public O findSelectedOption(@Nonnull String username) {
        return (O)((IdOption)this.findSelectedOption(IdOption.idMatches(this.optionClass, username)));
    }

    @Override
    @Nonnull
    public S removeOption(@Nonnull String id) {
        Poller.waitUntilTrue((TimedQuery)this.hasSelectedOption(id));
        IdOption option = (IdOption)Preconditions.checkNotNull(this.findSelectedOption(id));
        this.removeOption(option);
        Poller.waitUntilFalse((TimedQuery)this.hasSelectedOption(id));
        return (S)((IdSelect2)this.self());
    }

    @Override
    @Nonnull
    public S selectOption(@Nonnull String id) {
        Poller.waitUntilTrue((TimedQuery)this.hasOption(id));
        IdOption option = (IdOption)Preconditions.checkNotNull(this.findOption(id));
        this.selectOption(option);
        Poller.waitUntilFalse((TimedQuery)this.isOptionsOpen());
        Poller.waitUntilTrue((TimedQuery)this.hasSelectedOption(id));
        return (S)((IdSelect2)this.self());
    }
}

