/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.UserSelect;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class GroupUsersTable
extends AbstractElementPageObject {
    @Inject
    protected PageElementFinder elementFinder;
    @ElementBy(className="add-button")
    private PageElement addButton;
    private Long lastUpdated;
    private UserSelect userPicker;

    public GroupUsersTable(PageElement pageElement) {
        super(pageElement);
    }

    @WaitUntil
    protected void waitUntilLoaded() {
        ElementUtils.waitUntilUpdated(this.container, this.lastUpdated);
        this.lastUpdated = ElementUtils.getLastUpdated(this.container);
    }

    @Init
    protected void initUserPicker() {
        this.userPicker = (UserSelect)this.pageBinder.bind(UserSelect.class, new Object[]{this.container.find(By.className((String)"users-multi-selector"))});
    }

    public GroupUsersTable add(String name) {
        return this.add(name, false);
    }

    public GroupUsersTable add(String name, boolean expectError) {
        ((UserSelect)this.userPicker.type(name)).selectOption(name);
        this.addButton.click();
        if (!expectError) {
            this.waitUntilLoaded();
        } else {
            this.waitErrorMessage();
        }
        return this;
    }

    public GroupUsersTable remove(String name) {
        return this.remove(name, false);
    }

    public GroupUsersTable remove(String name, boolean expectError) {
        this.find(name).clickDelete();
        if (!expectError) {
            this.waitUntilLoaded();
        } else {
            this.waitErrorMessage();
        }
        return this;
    }

    public boolean canAdd(String name) {
        return this.userPicker.canAdd(name, new UserPredicate(name));
    }

    public List<Row> list() {
        return this.container.findAll(By.cssSelector((String)"tbody > tr"), Row.class);
    }

    public Row find(final String name) {
        return (Row)((Object)Iterables.find(this.list(), (Predicate)new Predicate<Row>(){

            public boolean apply(Row row) {
                return row.getName().equals(name);
            }
        }, null));
    }

    private void waitErrorMessage() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.className((String)"aui-message-error")).timed().isPresent());
    }

    private static class UserPredicate
    implements Predicate<PageElement> {
        private final String name;

        public UserPredicate(String name) {
            this.name = name;
        }

        public boolean apply(PageElement input) {
            return input.find(By.cssSelector((String)"[data-username]")).getAttribute("data-username").equals(this.name);
        }
    }

    public static class Row
    extends LegacyElementPageObject {
        @ElementBy(cssSelector=".avatar-with-name > a")
        private PageElement name;
        @ElementBy(className="delete-button")
        private PageElement deleteButton;

        public Row(PageElement pageElement) {
            super(pageElement);
        }

        public Row(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        public String getName() {
            return this.name.getText();
        }

        public void clickDelete() {
            ElementUtils.makeVisible(this.deleteButton);
            this.deleteButton.click();
        }
    }
}

