/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket;

import com.atlassian.pageobjects.Page;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.ProductInstance;
import com.atlassian.pageobjects.TestedProduct;
import com.atlassian.pageobjects.TestedProductFactory;
import com.atlassian.pageobjects.Tester;
import com.atlassian.pageobjects.binder.InjectPageBinder;
import com.atlassian.pageobjects.binder.StandardModule;
import com.atlassian.pageobjects.elements.ElementModule;
import com.atlassian.pageobjects.elements.timeout.TimeoutsModule;
import com.atlassian.webdriver.AtlassianWebDriverModule;
import com.atlassian.webdriver.pageobjects.DefaultWebDriverTester;
import com.atlassian.webdriver.pageobjects.WebDriverTester;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import javax.annotation.Nonnull;
import org.openqa.selenium.JavascriptExecutor;

public abstract class AbstractBitbucketTestedProduct
implements TestedProduct<WebDriverTester> {
    protected final PageBinder pageBinder;
    protected final WebDriverTester webDriverTester;
    protected final ProductInstance productInstance;

    public AbstractBitbucketTestedProduct(TestedProductFactory.TesterFactory<WebDriverTester> testerFactory, @Nonnull ProductInstance productInstance) {
        this.productInstance = (ProductInstance)Preconditions.checkNotNull((Object)productInstance);
        this.webDriverTester = testerFactory == null ? new DefaultWebDriverTester() : (WebDriverTester)testerFactory.create();
        this.pageBinder = new InjectPageBinder(productInstance, (Tester)this.webDriverTester, new Module[]{new StandardModule((TestedProduct)this), new ExtendedAtlassianWebDriverModule(this), new ElementModule(), new TimeoutsModule()});
        this.overridePages();
    }

    public PageBinder getPageBinder() {
        return this.pageBinder;
    }

    public ProductInstance getProductInstance() {
        return this.productInstance;
    }

    public WebDriverTester getTester() {
        return this.webDriverTester;
    }

    public <P extends Page> P visit(Class<P> pageClass, Object ... args) {
        return (P)this.pageBinder.navigateToAndBind(pageClass, args);
    }

    protected abstract void overridePages();

    protected class ExtendedAtlassianWebDriverModule
    extends AtlassianWebDriverModule {
        public ExtendedAtlassianWebDriverModule(TestedProduct<WebDriverTester> testedProduct) {
            super(testedProduct);
        }

        public void configure(Binder binder) {
            super.configure(binder);
            binder.bind(JavascriptExecutor.class).toInstance((Object)AbstractBitbucketTestedProduct.this.getTester().getDriver());
        }
    }
}

