/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page;

import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.BuildStatusDialog;
import com.atlassian.webdriver.bitbucket.element.Comment;
import com.atlassian.webdriver.bitbucket.element.GeneralCommentForm;
import com.atlassian.webdriver.bitbucket.element.Participant;
import com.atlassian.webdriver.bitbucket.element.activity.ActivityItem;
import com.atlassian.webdriver.bitbucket.element.activity.GeneralCommentActivity;
import com.atlassian.webdriver.bitbucket.element.tasks.PullRequestTaskListDialog;
import com.atlassian.webdriver.bitbucket.page.InlineMergeWarningDialog;
import com.atlassian.webdriver.bitbucket.page.MergeHelpDialog;
import com.atlassian.webdriver.bitbucket.page.PullRequestPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;

public class PullRequestOverviewPage
extends PullRequestPage<PullRequestOverviewPage> {
    public static int PAGE_SIZE = 25;
    private String queryParams = "";
    @ElementBy(cssSelector="#pull-request-activity .general-comment-form", pageElementClass=GeneralCommentForm.class)
    private GeneralCommentForm generalCommentForm;
    @ElementBy(cssSelector=".pull-request-content .description")
    private PageElement descriptionField;
    @ElementBy(className="pull-request-issues-trigger")
    private PageElement issuesDialogTrigger;
    @ElementBy(cssSelector="#pull-request-header .status")
    private PageElement mergedLozenge;
    @ElementBy(cssSelector=".watch a")
    private PageElement watchLink;

    public PullRequestOverviewPage(@Nonnull String projectKey, @Nonnull String slug, long pullRequestId, @Nullable Long commentId, @Nullable String action) {
        super(projectKey, slug, pullRequestId);
        this.queryParams = "?" + UrlUtils.buildQueryParams((Object[])new Object[]{"commentId", commentId, "action", action});
    }

    public PullRequestOverviewPage(String projectKey, String slug, long pullRequestId) {
        super(projectKey, slug, pullRequestId);
    }

    public boolean currentUserIsWatching() {
        return (Boolean)this.javascriptExecutor.executeScript("return require('bitbucket/internal/model/page-state').getIsWatching();", new Object[0]);
    }

    @Nonnull
    public <A extends ActivityItem> TimedQuery<Iterable<A>> getActivitiesOfType(@Nonnull Class<A> activityType) {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> Chainable.chain(this.getActivityItems()).filter(arg_0 -> ((Predicate)Predicates.instanceOf((Class)activityType)).apply(arg_0)).toList());
    }

    public List<ActivityItem> getActivityItems() {
        this.waitUntilActivityItemsLoaded();
        LinkedList elements = Lists.newLinkedList();
        List activitiesAndCommentForm = this.elementFinder.findAll(By.cssSelector((String)"#pull-request-activity > li"));
        Iterable activities = Iterables.skip((Iterable)activitiesAndCommentForm, (int)1);
        for (PageElement activityElement : activities) {
            elements.add(this.pageBinder.bind(ActivityItem.getType(activityElement), new Object[]{activityElement}));
        }
        return elements;
    }

    public Comment getGeneralCommentAt(int position) {
        GeneralCommentActivity activity = (GeneralCommentActivity)Iterables.get(this.getGeneralComments(), (int)position);
        return activity.getComment();
    }

    public GeneralCommentForm getGeneralCommentForm() {
        return this.generalCommentForm;
    }

    private Iterable<? extends ActivityItem> getGeneralComments() {
        return Iterables.filter(this.getActivityItems(), (Predicate)Predicates.instanceOf(GeneralCommentActivity.class));
    }

    public ActivityItem getLatestActivityItem() {
        PageElement activityElement = this.elementFinder.find(By.cssSelector((String)".activity-item"), TimeoutType.PAGE_LOAD);
        return (ActivityItem)this.pageBinder.bind(ActivityItem.getType(activityElement), new Object[]{activityElement});
    }

    public PageElement getMergedLozenge() {
        return this.mergedLozenge;
    }

    public PageElement getMergeStrategiesList() {
        return this.elementFinder.find(By.id((String)"merge-strategy-opts"), TimeoutType.PAGE_LOAD);
    }

    private PageElement getOpenTaskCountPanel() {
        return this.elementFinder.find(By.className((String)"plugin-item-task-count"));
    }

    public String getPullRequestDescriptionAsHtml() {
        return this.descriptionField.isPresent() ? ElementUtils.getHtml(this.descriptionField) : null;
    }

    private PullRequestTaskListDialog getPullRequestTaskListDialog() {
        return (PullRequestTaskListDialog)((Object)this.pageBinder.bind(PullRequestTaskListDialog.class, new Object[0]));
    }

    public List<Participant> getReviewers() {
        return this.elementFinder.find(By.className((String)"reviewer-avatar-list")).findAll(By.className((String)"aui-avatar-badged"), Participant.class);
    }

    @Override
    public String getUrl() {
        return super.getUrl() + "/overview" + this.queryParams;
    }

    public boolean hasBuildStatus() {
        return this.elementFinder.find(By.className((String)"build-icon")).isPresent();
    }

    public void loadNextPage() {
        this.waitUntilEventFired("bitbucket.internal.feature.pullRequestActivity.dataLoaded", () -> ElementUtils.scrollDocument(this.content));
    }

    @Nonnull
    public BuildStatusDialog openBuildStatus() {
        this.elementFinder.find(By.className((String)"build-icon")).click();
        return (BuildStatusDialog)((Object)this.pageBinder.bind(BuildStatusDialog.class, new Object[]{By.id((String)"build-status-dialog"), TimeoutType.DIALOG_LOAD}));
    }

    public MergeHelpDialog openMergeHelpDialog() {
        PageElement mergeInstructionsLink = this.content.find(By.cssSelector((String)".merge-conflicted-message .manual-merge"), TimeoutType.DEFAULT);
        mergeInstructionsLink.click();
        return (MergeHelpDialog)this.pageBinder.bind(MergeHelpDialog.class, new Object[0]);
    }

    public Optional<InlineMergeWarningDialog> openMergeInlineWarnings() {
        if (this.getMergeButton().isEnabled()) {
            return Optional.empty();
        }
        this.content.find(By.className((String)"merge-button")).click();
        return Optional.of(this.pageBinder.bind(InlineMergeWarningDialog.class, new Object[0]));
    }

    public PullRequestTaskListDialog openTaskListDialog() {
        PageElement panel = this.getOpenTaskCountPanel();
        panel.find(By.tagName((String)"a")).click();
        return this.getPullRequestTaskListDialog();
    }

    public PullRequestTaskListDialog openTaskListDialogWithKeyboardShortcut() {
        this.elementFinder.find(By.tagName((String)"body")).type(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.SHIFT, "t"})});
        return this.getPullRequestTaskListDialog();
    }

    public void unwatchPullRequest() {
        this.waitUntilEventFired("bitbucket.internal.web.watch-button.removed", () -> this.getWatchButton().click());
    }

    public int waitForOpenTaskCountPanel(boolean visible) {
        PageElement panel = this.getOpenTaskCountPanel();
        if (visible) {
            Poller.waitUntilTrue((TimedQuery)panel.timed().isVisible());
            return Integer.parseInt(panel.find(By.className((String)"task-count")).getAttribute("data-open"));
        }
        Poller.waitUntilFalse((TimedQuery)panel.timed().isVisible());
        return 0;
    }

    public void watchPullRequest() {
        this.waitUntilEventFired("bitbucket.internal.web.watch-button.added", () -> this.getWatchButton().click());
    }

    public boolean hasConflictMessage() {
        return this.content.find(By.cssSelector((String)".merge-conflicted-message")).isVisible();
    }

    @WaitUntil
    public void waitUntilActivityItemsLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.elementFinder.find(By.cssSelector((String)".activity-item,.general-comment-activity")).timed().isPresent());
    }
}

