/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.Avatar;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.LinkElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;

public class CommitMetadata
extends LegacyElementPageObject {
    public static final String className = "commit-metadata";

    public CommitMetadata(PageElement container) {
        super(container);
    }

    public CommitMetadata(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public String getAuthorName() {
        return this.find(By.className((String)"commit-author")).getText();
    }

    public Avatar getAuthorAvatar() {
        return (Avatar)this.find(By.cssSelector((String)".commit-metadata-user-avatar .user-avatar"), Avatar.class);
    }

    public String getDisplayDate() {
        return this.find(By.tagName((String)"time")).getText();
    }

    public String getMachineDate() {
        return this.find(By.tagName((String)"time")).getAttribute("datetime");
    }

    public String getMessage() {
        return this.find(By.className((String)"commit-message")).getText();
    }

    public boolean isMerge() {
        return this.getParents().size() > 1;
    }

    public List<CommitParent> getParents() {
        List links = this.findAll(By.cssSelector((String)".commit-parents .commitid"));
        ArrayList<CommitParent> parents = new ArrayList<CommitParent>(links.size());
        for (PageElement link : links) {
            parents.add(new CommitParent(link.getText()));
        }
        return parents;
    }

    public <T extends PageElement> T getPluginExtraDetails(By locator, Class<T> elementClass) {
        return (T)this.find(By.className((String)"commit-extra")).find(locator, elementClass);
    }

    public static class JiraIssueExtraDetails
    extends LegacyElementPageObject {
        public static final By LOCATOR = By.className((String)"jira-commit-metadata");

        public JiraIssueExtraDetails(PageElement container) {
            super(container);
        }

        public JiraIssueExtraDetails(By locator) {
            super(locator);
        }

        public JiraIssueExtraDetails(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public JiraIssueExtraDetails(By locator, WebDriverLocatable parent) {
            super(locator, parent);
        }

        public JiraIssueExtraDetails(By locator, WebDriverLocatable parent, TimeoutType timeoutType) {
            super(locator, parent, timeoutType);
        }

        public JiraIssueExtraDetails(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        public String getTriggerText() {
            List a = this.findAll(By.tagName((String)"a"), LinkElement.class);
            return ((LinkElement)((Object)a.get(0))).getText();
        }

        public String getDescription() {
            PageElement pageElement = this.find(By.className((String)"dropdown-text"));
            return pageElement.isPresent() ? pageElement.getText() : null;
        }

        public boolean canExpand() {
            return this.find(By.className((String)"aui-dd-trigger")).isPresent();
        }

        public JiraIssueExtraDetails expand() {
            this.find(By.className((String)"aui-dd-trigger")).click();
            return (JiraIssueExtraDetails)((Object)this.pageBinder.bind(JiraIssueExtraDetails.class, new Object[]{this.locatable, TimeoutType.UI_ACTION}));
        }

        public Collection<LinkElement> getVisibleJiraKeys() {
            return this.findAll(this.canExpand() ? By.cssSelector((String)".dropdown-item a") : By.tagName((String)"a"), LinkElement.class);
        }

        public int getNumberNotShown() {
            Matcher matcher;
            PageElement pageElement;
            if (this.canExpand() && (pageElement = this.find(By.cssSelector((String)".dropdown-item span"))).isPresent() && (matcher = Pattern.compile("(\\d+) more").matcher(pageElement.getText())).matches()) {
                return Integer.parseInt(matcher.group(1));
            }
            return 0;
        }
    }

    public static class CommitParent {
        private final String displayId;

        public CommitParent(String displayId) {
            this.displayId = displayId;
        }

        public String getDisplayId() {
            return this.displayId;
        }
    }
}

