/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.webhook;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.webhook.RepositoryWebhookPage;
import jakarta.inject.Inject;

public class RepositoryWebhookCreateResult {
    private final String projectKey;
    private final String repoSlug;
    @Inject
    private PageBinder pageBinder;
    @ElementBy(cssSelector=".field-group .error")
    private PageElement errorIndicator;

    public RepositoryWebhookCreateResult(String projectKey, String repoSlug) {
        this.projectKey = projectKey;
        this.repoSlug = repoSlug;
    }

    public RepositoryWebhookPage expectSuccess() {
        return (RepositoryWebhookPage)this.pageBinder.bind(RepositoryWebhookPage.class, new Object[]{this.projectKey, this.repoSlug});
    }

    public RepositoryWebhookPage expectFailure() {
        Poller.waitUntilTrue((TimedQuery)this.errorIndicator.timed().isVisible());
        return (RepositoryWebhookPage)this.pageBinder.bind(RepositoryWebhookPage.class, new Object[]{this.projectKey, this.repoSlug});
    }
}

