/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.secretscanning;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.AbstractTimedCondition;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.PollingQuery;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import com.atlassian.webdriver.bitbucket.page.secretscanning.SecretScanningCreatePage;
import com.atlassian.webdriver.bitbucket.page.secretscanning.SecretScanningRuleRow;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.openqa.selenium.By;

public class SecretScanningListPage
extends BitbucketAdminPage {
    @ElementBy(cssSelector="[data-testid=\"create-secret-scanning-rule\"]")
    private PageElement createButton;
    @ElementBy(cssSelector=".secret-scanning-search input")
    private PageElement searchInput;
    @ElementBy(className="secret-scanning-sort-button")
    private PageElement sortButton;
    @ElementBy(cssSelector=".secret-scanning-table table")
    private PageElement table;

    public SecretScanningListPage() {
    }

    public SecretScanningListPage(String webSudoPassword) {
        super(webSudoPassword);
    }

    public String getUrl() {
        return "/admin/secret-scanning";
    }

    public void waitUntilLoaded() {
        this.waitUntilLoaded(25);
    }

    public void waitUntilLoaded(final int minExpectedElements) {
        Poller.waitUntilTrue((TimedQuery)new AbstractTimedCondition((PollingQuery)this.table.timed().isVisible()){

            protected Boolean currentValue() {
                return SecretScanningListPage.this.elementFinder.findAll(By.className((String)"secret-scanning-row")).size() >= minExpectedElements;
            }
        });
    }

    public void scrollToNextPage(int minExpectedElements) {
        this.scrollToBottom();
        this.waitUntilLoaded(minExpectedElements);
    }

    public SecretScanningRuleRow getRule(String ruleName) {
        return this.getRules().stream().filter(rule -> ruleName.equals(rule.getName())).findFirst().orElseThrow(() -> new IllegalArgumentException("No rule with name " + ruleName));
    }

    public List<SecretScanningRuleRow> getRules() {
        return this.elementFinder.findAll(By.className((String)"secret-scanning-row")).stream().map(ElementUtils.bind(this.pageBinder, SecretScanningRuleRow.class, this.elementFinder)).collect(Collectors.toList());
    }

    public SecretScanningListPage sortByRuleName() {
        this.sortButton.click();
        this.waitUntilLoaded();
        return (SecretScanningListPage)this.pageBinder.bind(SecretScanningListPage.class, new Object[0]);
    }

    public SecretScanningCreatePage clickCreate() {
        this.createButton.click();
        return (SecretScanningCreatePage)this.pageBinder.bind(SecretScanningCreatePage.class, new Object[0]);
    }

    public SecretScanningListPage search(String filter) {
        final String before = this.table.getText();
        this.searchInput.clear();
        this.searchInput.type(new CharSequence[]{filter});
        AsyncTestUtils.waitFor((WaitCondition)new WaitCondition(){

            public boolean test() throws Exception {
                return !before.equals(SecretScanningListPage.this.table.getText());
            }

            public void describeFailure(Description description) throws Exception {
                description.appendText("The content of the table should change");
            }
        }, (long)2000L);
        return (SecretScanningListPage)this.pageBinder.bind(SecretScanningListPage.class, new Object[0]);
    }
}

