/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.automerge;

import com.atlassian.bitbucket.pageobjects.element.ProjectSettingsRestrictionSelector;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.page.automerge.AbstractAutoMergeSettingsPage;
import jakarta.annotation.Nonnull;

public class ProjectAutoMergeSettingsPage
extends AbstractAutoMergeSettingsPage {
    private final String projectKey;
    @ElementBy(cssSelector="[data-testid='cancel-confirmation-modal']")
    private PageElement restrictionConfirmationModal;
    @ElementBy(className="project-settings-selector")
    private PageElement restrictionDropdown;

    public ProjectAutoMergeSettingsPage(String projectKey) {
        this.projectKey = projectKey;
    }

    public RestrictionConfirmationDialog getRestrictionConfirmationModal() {
        Poller.waitUntilTrue((TimedQuery)this.restrictionConfirmationModal.timed().isVisible());
        return (RestrictionConfirmationDialog)this.pageBinder.bind(RestrictionConfirmationDialog.class, new Object[]{this.restrictionConfirmationModal});
    }

    public ProjectSettingsRestrictionSelector getRestrictionDropdown() {
        Poller.waitUntilTrue((TimedQuery)this.restrictionDropdown.timed().isVisible());
        return (ProjectSettingsRestrictionSelector)this.pageBinder.bind(ProjectSettingsRestrictionSelector.class, new Object[]{this.restrictionDropdown});
    }

    public String getUrl() {
        return "/projects/" + this.projectKey + "/settings/auto-merge";
    }

    @Override
    public boolean isAutoMergeEnabled() {
        Poller.waitUntilTrue((TimedQuery)this.enabledCheckbox.timed().isPresent());
        return this.enabledCheckbox.isSelected();
    }

    public static class RestrictionConfirmationDialog
    extends AbstractElementPageObject {
        @ElementBy(cssSelector="[data-testid='cancel-confirmation-modal-cancel-button']")
        private PageElement cancelButton;
        @ElementBy(cssSelector="[data-testid='cancel-confirmation-modal-confirm-button']")
        private PageElement confirmButton;

        public RestrictionConfirmationDialog(@Nonnull PageElement container) {
            super(container);
        }

        public void clickCancel() {
            this.cancelButton.click();
        }

        public void clickConfirm() {
            this.confirmButton.click();
        }
    }
}

