/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.repositorymanagement;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.testing.PageElementMatchers;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.openqa.selenium.By;

public class StatusSelector
extends AbstractElementPageObject {
    private static final String ACTIVE = "Active";
    private static final String ARCHIVED = "Archived";
    private static final String ALL = "All";

    public StatusSelector(@Nonnull PageElement container) {
        super(container);
    }

    public String getSelectedStatus() {
        return this.container.find(By.className((String)"status-filter__single-value")).getText();
    }

    public void selectActiveRepositories() {
        this.selectStatus(ACTIVE);
    }

    public void selectArchivedRepositories() {
        this.selectStatus(ARCHIVED);
    }

    public void selectAllRepositories() {
        this.selectStatus(ALL);
    }

    private void selectStatus(String status) {
        this.container.click();
        ((List)Poller.waitUntil(this.getOptions(), (Matcher)CoreMatchers.hasItem((Matcher)PageElementMatchers.withText((String)status)))).stream().filter(p -> status.equals(p.getText())).findFirst().orElseThrow(() -> new AssertionError((Object)String.format("%s not found in the location selector drop-down", status))).click();
    }

    private TimedQuery<List<PageElement>> getOptions() {
        return Queries.forSupplier((Timeouts)this.timeouts, () -> this.container.findAll(By.className((String)"status-filter__option")));
    }
}

