/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.mirror;

import com.atlassian.bitbucket.pageobjects.element.Flag;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.page.admin.mirror.AbstractMirrorConfigPage;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class MirrorLoggingProfilingPage
extends AbstractMirrorConfigPage {
    @ElementBy(cssSelector="[data-testid='logging-profiling-cancel']")
    private PageElement cancelButton;
    @ElementBy(name="debugLogging")
    private PageElement debugLoggingCheckbox;
    @ElementBy(name="profiling")
    private PageElement profilingCheckbox;
    @ElementBy(cssSelector="[data-testid='logging-profiling-save']")
    private PageElement saveButton;

    public MirrorLoggingProfilingPage(String type, String mirrorId) {
        super(type, mirrorId);
    }

    public void cancel() {
        this.cancelButton.click();
    }

    @WaitUntil
    public void ensureContentIsLoaded() {
        Poller.waitUntilTrue((TimedQuery)this.debugLoggingCheckbox.timed().isEnabled());
    }

    public TimedCondition isDebugLoggingEnabled() {
        return this.debugLoggingCheckbox.timed().isSelected();
    }

    public TimedCondition isProfilingEnabled() {
        return this.profilingCheckbox.timed().isSelected();
    }

    public void save() {
        this.saveButton.click();
        Flag successAlert = (Flag)((List)Poller.waitUntil((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, this::getFlags), (Matcher)Matchers.not((Matcher)Matchers.empty()))).get(0);
        MatcherAssert.assertThat((Object)successAlert.getTitle(), (Matcher)Matchers.equalTo((Object)"Successfully saved logging and profiling settings."));
    }

    public void toggleDebugLoggingEnabled() {
        this.debugLoggingCheckbox.click();
    }

    public void toggleProfilingEnabled() {
        this.profilingCheckbox.click();
    }
}

