/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin.jiracommitchecker;

import com.atlassian.bitbucket.pageobjects.element.KeywordsInput;
import com.atlassian.bitbucket.pageobjects.element.UserMultiSelector;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.BaseSidebarPage;
import org.openqa.selenium.By;

public abstract class AbstractJiraCommitCheckerAdminPage
extends BaseSidebarPage {
    @ElementBy(className="cancel-button")
    private PageElement cancelButton;
    @ElementBy(className="exempt-messages-select")
    private PageElement exemptMessages;
    @ElementBy(className="exempt-pushers-select")
    private PageElement exemptPushers;
    @ElementBy(cssSelector="input[name='hook-state'][value='JIRA_VALIDATION']")
    private PageElement hookStateJiraValidation;
    @ElementBy(cssSelector="input[name='hook-state'][value='OFF']")
    private PageElement hookStateOff;
    @ElementBy(cssSelector="input[name='hook-state'][value='REGEX_MATCHING']")
    private PageElement hookStateRegexMatching;
    @ElementBy(cssSelector="[data-testid='ignore-merge-commits-checkbox--checkbox-label']")
    private PageElement ignoreMergeCommits;
    @ElementBy(className="save-button")
    private PageElement saveButton;
    @ElementBy(cssSelector="[data-testid='save-success-flag']")
    private PageElement saveSuccessfulFlag;

    public void cancel() {
        this.cancelButton.click();
    }

    public KeywordsInput getExemptCommitMessages() {
        return (KeywordsInput)this.pageBinder.bind(KeywordsInput.class, new Object[]{this.exemptMessages});
    }

    public UserMultiSelector getExemptPushers() {
        return (UserMultiSelector)this.pageBinder.bind(UserMultiSelector.class, new Object[]{this.exemptPushers});
    }

    public HookState getHookState() {
        if (this.hookStateOff.isSelected()) {
            return HookState.OFF;
        }
        if (this.hookStateJiraValidation.isSelected()) {
            return HookState.JIRA_VALIDATION;
        }
        if (this.hookStateRegexMatching.isSelected()) {
            return HookState.REGEX_MATCHING;
        }
        return null;
    }

    public boolean isIgnoreMergeCommitsSelected() {
        return this.ignoreMergeCommits.find(By.tagName((String)"input")).isSelected();
    }

    public void save() {
        this.saveButton.click();
        Poller.waitUntilTrue((TimedQuery)this.saveSuccessfulFlag.timed().isVisible());
    }

    public void selectHookState(HookState hookState) {
        switch (hookState.ordinal()) {
            case 0: {
                this.hookStateOff.click();
                break;
            }
            case 1: {
                this.hookStateJiraValidation.click();
                break;
            }
            case 2: {
                this.hookStateRegexMatching.click();
            }
        }
    }

    public void setIgnoreMergeCommits(boolean select) {
        boolean isSelected = this.isIgnoreMergeCommitsSelected();
        if (isSelected && !select || !isSelected && select) {
            this.ignoreMergeCommits.click();
        }
    }

    public static enum HookState {
        OFF,
        JIRA_VALIDATION,
        REGEX_MATCHING;

    }
}

