/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.page.admin;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.Dialog2;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;

public class MailServerConfigPage
extends BitbucketAdminPage {
    @ElementBy(className="stash-mailserver-form")
    private PageElement parentForm;
    @ElementBy(id="hostname")
    private PageElement hostname;
    @ElementBy(id="serverEmail")
    private PageElement serverEmail;
    @ElementBy(id="port")
    private PageElement port;
    @ElementBy(id="username")
    private PageElement username;
    @ElementBy(id="password")
    private PageElement password;
    @ElementBy(id="save")
    private PageElement saveButton;
    @ElementBy(id="delete")
    private PageElement deleteButton;
    @ElementBy(id="testAddress")
    private PageElement testAddresss;
    @ElementBy(id="test")
    private PageElement testButton;
    @ElementBy(cssSelector="#testButtonContainer .success")
    private PageElement testSuccessMessage;
    @ElementBy(cssSelector="#testButtonContainer .error")
    private PageElement testFailureMessage;
    @ElementBy(cssSelector=".aui-message-info")
    private PageElement deletedMessage;
    @ElementBy(cssSelector=".autofill-protected-password-overlay")
    private PageElement passwordOverlay;

    public MailServerConfigPage() {
    }

    public MailServerConfigPage(String webSudoPassword) {
        super(webSudoPassword);
    }

    public String getUrl() {
        return "/admin/mail-server";
    }

    public MailServerConfigPage setHostname(String hostname) {
        this.hostname.clear().type(new CharSequence[]{hostname});
        return this;
    }

    public MailServerConfigPage setServerEmailAddress(String serverEmailAddress) {
        this.serverEmail.clear().type(new CharSequence[]{serverEmailAddress});
        return this;
    }

    public MailServerConfigPage setPort(String port) {
        this.port.clear().type(new CharSequence[]{port});
        return this;
    }

    public MailServerConfigPage setUsername(String username) {
        this.username.clear().type(new CharSequence[]{username});
        return this;
    }

    public MailServerConfigPage setPassword(String password) {
        this.passwordOverlay.click();
        if (StringUtils.isEmpty((CharSequence)password)) {
            this.password.clear().type(new CharSequence[]{" "}).clear();
        } else {
            this.password.clear().type(new CharSequence[]{password});
        }
        return this;
    }

    public MailServerConfigPage setTestAddress(String testAddress) {
        this.testAddresss.clear().type(new CharSequence[]{testAddress});
        return this;
    }

    public String getHostname() {
        return this.hostname.getValue();
    }

    public String getServerEmailAddress() {
        return this.serverEmail.getValue();
    }

    public String getPassword() {
        return this.password.getValue();
    }

    public String getPasswordError() {
        return this.elementFinder.find(By.id((String)"password-error-message-0")).getText();
    }

    public String getPort() {
        return this.port.getValue();
    }

    public String getUsername() {
        return this.username.getValue();
    }

    public String getTestAddress() {
        return this.testAddresss.getValue();
    }

    public String getTestSuccessMessage() {
        return this.testSuccessMessage.getText();
    }

    public String getTestFailureMessage() {
        return this.testFailureMessage.getText();
    }

    public MailServerConfigPage clickSave() {
        this.saveButton.click();
        return this;
    }

    public MailServerConfigPage clickDelete() {
        this.deleteButton.click();
        Dialog2 dialog = (Dialog2)this.elementFinder.find(By.id((String)"delete-mail-sever-config-dialog"), Dialog2.class);
        Poller.waitUntilTrue((TimedQuery)dialog.isOpen());
        return this;
    }

    public MailServerConfigPage clickDeleteConfirm() {
        this.waitForPageLoad(new Runnable(){

            @Override
            public void run() {
                Dialog2 dialog = (Dialog2)MailServerConfigPage.this.elementFinder.find(By.id((String)"delete-mail-sever-config-dialog"), Dialog2.class);
                dialog.clickMainAction();
            }
        });
        return this;
    }

    public MailServerConfigPage clickTest() {
        this.waitForPageLoad(new Runnable(){

            @Override
            public void run() {
                MailServerConfigPage.this.testButton.click();
            }
        });
        return this;
    }

    public List<String> getFieldsWithErrors() {
        return this.getFieldsWithErrors(this.parentForm);
    }

    public String getDeletedMessage() {
        if (this.deletedMessage.isPresent()) {
            return this.deletedMessage.getText().trim();
        }
        return null;
    }
}

