/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.webdriver.bitbucket.element.AccessKeyOption;
import com.atlassian.webdriver.bitbucket.element.GroupOption;
import com.atlassian.webdriver.bitbucket.element.IdOption;
import com.atlassian.webdriver.bitbucket.element.UserOption;
import com.google.common.base.MoreObjects;
import com.google.common.base.Predicate;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;

public class UserAndGroupOption
extends IdOption {
    @Inject
    protected PageBinder pageBinder;

    public UserAndGroupOption(PageElement container) {
        super(container);
    }

    @Nonnull
    public static Predicate<UserAndGroupOption> idMatches(@Nonnull String id) {
        return IdOption.idMatches(UserAndGroupOption.class, id);
    }

    @Nullable
    public String getDisplayName() {
        if (!this.isUserOption()) {
            return null;
        }
        return this.getUserOption().getDisplayName();
    }

    @Nullable
    public String getAccessKeyLabel() {
        if (!this.isAccessKeyOption()) {
            return null;
        }
        return this.getAccessKeyOption().getId();
    }

    @Nullable
    public String getGroupName() {
        if (!this.isGroupOption()) {
            return null;
        }
        return this.getGroupOption().getGroupName();
    }

    @Override
    @Nullable
    public String getId() {
        if (this.isGroupOption()) {
            return this.getGroupName();
        }
        if (this.isUserOption()) {
            return this.getUsername();
        }
        if (this.isAccessKeyOption()) {
            return this.getAccessKeyLabel();
        }
        throw new AssertionError((Object)("Unrecognized option: " + String.valueOf(this)));
    }

    @Nullable
    public String getUsername() {
        if (!this.isUserOption()) {
            return null;
        }
        return this.getUserOption().getUsername();
    }

    public boolean isAccessKeyOption() {
        return this.getAccessKeyOption().getLabel().isPresent();
    }

    public boolean isGroupOption() {
        return this.getGroupOption().getGroupContainer().isPresent();
    }

    public boolean isUserOption() {
        return this.getUserOption().getUsernameContainer().isPresent();
    }

    @Nonnull
    protected AccessKeyOption getAccessKeyOption() {
        return (AccessKeyOption)this.pageBinder.bind(AccessKeyOption.class, new Object[]{this.container});
    }

    @Nonnull
    protected GroupOption getGroupOption() {
        return (GroupOption)this.pageBinder.bind(GroupOption.class, new Object[]{this.container});
    }

    @Nonnull
    protected UserOption getUserOption() {
        return (UserOption)this.pageBinder.bind(UserOption.class, new Object[]{this.container});
    }

    @Override
    protected void extendToString(MoreObjects.ToStringHelper toStringHelper) {
        toStringHelper.add("id", (Object)this.getId());
    }
}

