/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.webdriver.bitbucket.BuildStatusIcon;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.SearchableSelector;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import org.openqa.selenium.By;

public class SourceTargetSelector {
    @Inject
    private PageBinder pageBinder;
    @Inject
    private PageElementFinder elementFinder;
    @ElementBy(id="sourceRepo")
    private PageElement sourceRepoSelector;
    @ElementBy(id="sourceRepo-field")
    private PageElement sourceRepoField;
    @ElementBy(id="sourceBranch")
    private PageElement sourceBranchSelector;
    @ElementBy(id="sourceBranch-field")
    private PageElement sourceBranchField;
    @ElementBy(id="targetRepo")
    private PageElement targetRepoSelector;
    @ElementBy(id="targetRepo-field")
    private PageElement targetRepoField;
    @ElementBy(id="targetBranch")
    private PageElement targetBranchSelector;
    @ElementBy(id="targetBranch-field")
    private PageElement targetBranchField;

    public SearchableSelector getSourceRepositorySelector() {
        return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.sourceRepoSelector, By.id((String)"sourceRepoDialog"), this.sourceRepoField});
    }

    public SearchableSelector getSourceBranchSelector() {
        return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.sourceBranchSelector, By.id((String)"sourceBranchDialog"), this.sourceBranchField});
    }

    public SearchableSelector getTargetRepositorySelector() {
        return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.targetRepoSelector, By.id((String)"targetRepoDialog"), this.targetRepoField});
    }

    public SearchableSelector getTargetBranchSelector() {
        return (SearchableSelector)this.pageBinder.bind(SearchableSelector.class, new Object[]{this.targetBranchSelector, By.id((String)"targetBranchDialog"), this.targetBranchField});
    }

    public CommitBadge getSourceChangsetBadge() {
        return (CommitBadge)((Object)this.pageBinder.bind(CommitBadge.class, new Object[]{By.cssSelector((String)".source-selector .commit-badge-detailed")}));
    }

    public CommitBadge getTargetChangsetBadge() {
        return (CommitBadge)((Object)this.pageBinder.bind(CommitBadge.class, new Object[]{By.cssSelector((String)".target-selector .commit-badge-detailed")}));
    }

    public BuildStatusIcon getSourceBuildIcon() {
        return this.getBuildStatusIcon("source");
    }

    public BuildStatusIcon getTargetBuildIcon() {
        return this.getBuildStatusIcon("target");
    }

    private BuildStatusIcon getBuildStatusIcon(String selector) {
        PageElement icon = this.elementFinder.find(By.cssSelector((String)("#build-status-" + selector + "-selector .build-icon")));
        return (BuildStatusIcon)this.pageBinder.bind(BuildStatusIcon.class, new Object[]{icon});
    }

    public static class CommitBadge
    extends LegacyElementPageObject {
        public CommitBadge(@Nonnull PageElement pageElement) {
            super(pageElement);
        }

        public CommitBadge(By locator) {
            super(locator);
        }

        public String getAuthor() {
            return this.find(By.className((String)"commit-author")).getText();
        }

        public String getId() {
            return this.find(By.className((String)"commitid")).getText();
        }

        public String getDate() {
            return this.find(By.tagName((String)"time")).getText();
        }
    }
}

