/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.page.ProjectOverviewPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.Locators;
import java.util.List;
import org.openqa.selenium.By;

public class ProjectTable
extends LegacyElementPageObject {
    public ProjectTable(PageElement pageElement) {
        super(pageElement);
    }

    public ProjectTable(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public ProjectRow findProjectByName(String projectName) {
        for (ProjectRow row : this.getProjects()) {
            if (!row.getProjectName().equals(projectName)) continue;
            return row;
        }
        return null;
    }

    public List<ProjectRow> getProjects() {
        return this.findAll(Locators.tableRow(), ProjectRow.class);
    }

    public void loadNextPage() {
        ElementUtils.scrollDocumentAndWait((PageElement)this);
    }

    public static class ProjectRow
    extends LegacyElementPageObject {
        public ProjectRow(PageElement pageElement) {
            super(pageElement);
        }

        public ProjectRow(By locator, TimeoutType timeoutType) {
            super(locator, timeoutType);
        }

        public ProjectRow(WebDriverLocatable locatable, TimeoutType timeoutType) {
            super(locatable, timeoutType);
        }

        private PageElement getNameColumn() {
            return (PageElement)this.findAll(By.tagName((String)"td")).get(0);
        }

        private PageElement getKeyColumn() {
            return (PageElement)this.findAll(By.tagName((String)"td")).get(1);
        }

        private PageElement getDescriptionColumn() {
            return (PageElement)this.findAll(By.tagName((String)"td")).get(2);
        }

        public String getProjectName() {
            return this.getNameColumn().getText();
        }

        public String getProjectKey() {
            return this.getKeyColumn().getText();
        }

        public String getProjectDescription() {
            return this.getDescriptionColumn().getText();
        }

        public ProjectOverviewPage goToProjectPage() {
            String projectKey = this.getProjectKey();
            this.getNameColumn().find(By.tagName((String)"a")).click();
            return (ProjectOverviewPage)this.pageBinder.bind(ProjectOverviewPage.class, new Object[]{projectKey});
        }
    }
}

