/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.aui.auipageobjects.AuiCheckbox;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.webdriver.bitbucket.element.Dialog2;
import com.atlassian.webdriver.bitbucket.element.UserAndGroupSelect;
import com.atlassian.webdriver.bitbucket.page.admin.settings.ref.restriction.AbstractBranchPermissionsPage;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import java.util.List;
import org.openqa.selenium.By;

public abstract class PermissionDialog
extends Dialog2 {
    static final String CONTAINER_ID = "branch-permissions-dialog";
    protected final AbstractBranchPermissionsPage parent;

    public PermissionDialog(AbstractBranchPermissionsPage parent) {
        super(By.id((String)CONTAINER_ID));
        this.parent = parent;
    }

    public void cancel() {
        this.clickCancel();
    }

    public void checkBoxes(boolean ... checkBoxes) {
        List<AuiCheckbox> checkboxList = this.getCheckboxes();
        int i = 0;
        for (AuiCheckbox checkbox : checkboxList) {
            if (checkBoxes.length > i) {
                checkbox.click();
            }
            ++i;
        }
    }

    public String getEditSubject() {
        return this.find(By.className((String)"branch-name-text")).getText();
    }

    public UserAndGroupSelect getFirstUsersAndGroups() {
        return this.getUsersAndGroupSelectFor(this.getFirstCheckbox());
    }

    public void submit() {
        this.clickMainAction();
        this.parent.closeFlags();
    }

    public boolean submitExpectingError() {
        this.mainActionButton.click();
        return this.find(By.cssSelector((String)".error")).isVisible();
    }

    public AbstractBranchPermissionsPage.BranchPermissionDialog switchToBranch() {
        this.changeBranchType("BRANCH");
        return (AbstractBranchPermissionsPage.BranchPermissionDialog)((Object)this.pageBinder.bind(AbstractBranchPermissionsPage.BranchPermissionDialog.class, new Object[]{this.parent}));
    }

    public AbstractBranchPermissionsPage.PatternPermissionDialog switchToPattern() {
        this.changeBranchType("PATTERN");
        return (AbstractBranchPermissionsPage.PatternPermissionDialog)((Object)this.pageBinder.bind(AbstractBranchPermissionsPage.PatternPermissionDialog.class, new Object[]{this.parent}));
    }

    public AbstractBranchPermissionsPage.BranchModelPermissionDialog switchToModel() {
        this.changeBranchType("MODEL");
        return (AbstractBranchPermissionsPage.BranchModelPermissionDialog)((Object)this.pageBinder.bind(AbstractBranchPermissionsPage.BranchModelPermissionDialog.class, new Object[]{this.parent}));
    }

    protected void changeBranchType(String type) {
        ElementUtils.findCheckbox((PageElementFinder)this, By.cssSelector((String)("input[value='" + type + "']"))).click();
    }

    @Override
    By getCancelLinkLocator() {
        return By.id((String)"cancel-permission-button");
    }

    @Override
    By getMainActionLocator() {
        return By.id((String)"save-permission-button");
    }

    private List<AuiCheckbox> getCheckboxes() {
        return ElementUtils.findCheckboxes((PageElementFinder)this, By.cssSelector((String)"input[type='checkbox']"));
    }

    private PageElement getFirstCheckbox() {
        return (PageElement)this.getCheckboxes().get(0);
    }

    public void setFirstCheckbox(boolean checked) {
        AuiCheckbox checkbox = this.getCheckboxes().get(0);
        if (checkbox.isSelected() != checked) {
            checkbox.click();
        }
    }

    private UserAndGroupSelect getUsersAndGroupSelectFor(PageElement checkbox) {
        return (UserAndGroupSelect)this.pageBinder.bind(UserAndGroupSelect.class, new Object[]{this.find(By.id((String)("s2id_" + checkbox.getId() + "-input")))});
    }
}

