/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.atlassian.webdriver.bitbucket.element.Avatar;
import com.atlassian.webdriver.bitbucket.element.InfiniteScrollDialog;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import com.atlassian.webdriver.bitbucket.element.LinkElement;
import com.atlassian.webdriver.bitbucket.page.CommitPullRequestListDialog;
import com.atlassian.webdriver.bitbucket.util.DateUtils;
import com.google.common.collect.Iterables;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;

public class CommitMetadata
extends LegacyElementPageObject {
    public static final String className = "commit-metadata";

    public CommitMetadata(PageElement container) {
        super(container);
    }

    public CommitMetadata(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public String getAuthorName() {
        return this.find(By.className((String)"commit-author")).getText();
    }

    public Avatar getAuthorAvatar() {
        return (Avatar)this.find(By.cssSelector((String)".commit-metadata-user-avatar .user-avatar"), Avatar.class);
    }

    public DeploymentExtraDetails getDeploymentExtraDetails() {
        return this.getPluginExtraDetails(DeploymentExtraDetails.LOCATOR, DeploymentExtraDetails.class);
    }

    public String getDisplayDate() {
        return this.find(By.tagName((String)"time")).getText();
    }

    public DownloadExtraDetails getDownloadExtraDetails() {
        return this.getPluginExtraDetails(DownloadExtraDetails.LOCATOR, DownloadExtraDetails.class);
    }

    public JiraIssueExtraDetails getJiraIssueExtraDetails() {
        return this.getPluginExtraDetails(JiraIssueExtraDetails.LOCATOR, JiraIssueExtraDetails.class);
    }

    public String getMachineDate() {
        return this.find(By.tagName((String)"time")).getAttribute("datetime");
    }

    public String getMessage() {
        return this.find(By.className((String)"commit-message")).getText();
    }

    public boolean isMerge() {
        return this.getParents().size() > 1;
    }

    public List<CommitParent> getParents() {
        List links = this.findAll(By.cssSelector((String)".commit-parents .commitid"));
        ArrayList<CommitParent> parents = new ArrayList<CommitParent>(links.size());
        for (PageElement link : links) {
            parents.add(new CommitParent(link.getText()));
        }
        return parents;
    }

    public <T extends PageElement> T getPluginExtraDetails(By locator, Class<T> elementClass) {
        return (T)this.find(By.className((String)"commit-extra")).find(locator, elementClass);
    }

    public PullRequestsSummary getPullRequestsSummary() {
        PageElement element = this.find(By.className((String)"commit-pull-requests-summary"));
        return new PullRequestsSummary(new Integer(element.find(By.className((String)"count")).getText()), element.find(By.cssSelector((String)".label")).getText());
    }

    public boolean hasPullRequestsSummary() {
        return (Boolean)this.find(By.className((String)"commit-pull-requests-summary")).timed().isVisible().byDefaultTimeout();
    }

    public CommitPullRequestListDialog openPullRequestListDialog() {
        CommitPullRequestListDialog dialog = this.openPullRequestListDialogWithoutWaitingForEvent();
        Poller.waitUntilTrue((TimedQuery)dialog.getPullRequestList().timed().isVisible());
        return dialog;
    }

    public CommitPullRequestListDialog openPullRequestListDialogWithoutWaitingForEvent() {
        PageElement link = this.find(By.className((String)"commit-pull-requests-summary-link"));
        Poller.waitUntilTrue((TimedQuery)link.timed().isVisible());
        link.click();
        CommitPullRequestListDialog dialog = (CommitPullRequestListDialog)((Object)this.pageBinder.bind(CommitPullRequestListDialog.class, new Object[]{By.id((String)"pull-request-list-dialog"), TimeoutType.DIALOG_LOAD}));
        Poller.waitUntilTrue((TimedQuery)dialog.isOpen());
        return dialog;
    }

    public static class DeploymentExtraDetails
    extends LegacyElementPageObject {
        public static final By LOCATOR = By.className((String)"commit-deployments-summary");

        public DeploymentExtraDetails(By locator, WebDriverLocatable parent) {
            super(locator, parent);
        }

        public DeploymentsDialog openDialog() {
            this.find(By.className((String)"commit-deployments-summary-link")).click();
            DeploymentsDialog dialog = (DeploymentsDialog)((Object)this.pageBinder.bind(DeploymentsDialog.class, new Object[0]));
            dialog.waitUntilPageLoaded();
            return dialog;
        }

        public static class DeploymentsDialog
        extends InfiniteScrollDialog<DeploymentListRow> {
            public DeploymentsDialog() {
                super(By.className((String)"commit-pull-requests-summary-link"), By.id((String)"list-deployments-inline-dialog"));
            }

            @Override
            public DeploymentListRow findItem(String s) {
                return this.getItems().stream().filter(item -> s.equals(item.getEnvironmentName())).findFirst().orElseThrow(() -> new RuntimeException("Could not find deployment with environment " + s));
            }

            @Override
            public List<DeploymentListRow> getItems() {
                return this.findAll(By.tagName((String)"tr"), DeploymentListRow.class);
            }

            @Override
            public void loadNextPage() {
                this.javascript().execute("var $deploymentList = jQuery(\"#deployments-list\");\nvar $deploymentRows = jQuery(\"#deployments-list table tbody\").children(\"tr\");\n$deploymentList.scrollTop($deploymentRows.size() * $deploymentRows.height());", new Object[0]);
                this.waitUntilPageLoaded();
            }

            @Override
            public void waitUntilPageLoaded() {
                Poller.waitUntilFalse((TimedQuery)this.find(By.cssSelector((String)"#deployments-list .spinner")).timed().isVisible());
            }
        }

        public static class DeploymentListRow
        extends WebDriverElement {
            public DeploymentListRow(WebDriverLocatable locatable, TimeoutType timeoutType) {
                super(locatable, timeoutType);
            }

            public void clickEnvironmentUrl() {
                String originWindow = this.driver.getWindowHandle();
                this.find(By.cssSelector((String)".environment-name a")).click();
                Poller.waitUntilEquals((Object)2, (TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, () -> this.driver.getWindowHandles().size()));
                this.driver.switchTo().window((String)Iterables.getLast((Iterable)this.driver.getWindowHandles()));
                this.driver.close();
                this.driver.switchTo().window(originWindow);
            }

            public String getEnvironmentName() {
                return this.find(By.cssSelector((String)".environment-name a")).getText();
            }

            public String getEnvironmentUrl() {
                return this.find(By.cssSelector((String)".environment-name a")).getAttribute("href");
            }

            public Instant getDate() {
                String time = this.find(By.cssSelector((String)".deployment-date time")).getAttribute("datetime");
                return DateUtils.parseServerTimestamp(time).toInstant();
            }
        }
    }

    public static class DownloadExtraDetails
    extends LegacyElementPageObject {
        public static final By LOCATOR = By.className((String)"download");

        public DownloadExtraDetails(By locator, WebDriverLocatable parent) {
            super(locator, parent);
        }

        public String getUrl() {
            return ((LinkElement)this.find(By.tagName((String)"a"), LinkElement.class)).getUrl();
        }
    }

    public static class JiraIssueExtraDetails
    extends LegacyElementPageObject {
        public static final By LOCATOR = By.className((String)"jira-commit-metadata");

        public JiraIssueExtraDetails(By locator, WebDriverLocatable parent) {
            super(locator, parent);
        }

        public String getTriggerText() {
            List a = this.findAll(By.tagName((String)"a"), LinkElement.class);
            return ((LinkElement)((Object)a.get(0))).getText();
        }

        public String getDescription() {
            PageElement pageElement = this.find(By.className((String)"dropdown-text"));
            return pageElement.isPresent() ? pageElement.getText() : null;
        }

        public boolean canExpand() {
            return this.find(By.className((String)"aui-dd-trigger")).isPresent();
        }

        public JiraIssueExtraDetails expand() {
            this.find(By.className((String)"aui-dd-trigger")).click();
            return (JiraIssueExtraDetails)((Object)this.pageBinder.bind(JiraIssueExtraDetails.class, new Object[]{this.locatable, TimeoutType.UI_ACTION}));
        }

        public Collection<LinkElement> getVisibleJiraKeys() {
            return this.findAll(this.canExpand() ? By.cssSelector((String)".dropdown-item a") : By.tagName((String)"a"), LinkElement.class);
        }

        public int getNumberNotShown() {
            Matcher matcher;
            PageElement pageElement;
            if (this.canExpand() && (pageElement = this.find(By.cssSelector((String)".dropdown-item span"))).isPresent() && (matcher = Pattern.compile("(\\d+) more").matcher(pageElement.getText())).matches()) {
                return Integer.parseInt(matcher.group(1));
            }
            return 0;
        }
    }

    public static class CommitParent {
        private final String displayId;

        public CommitParent(String displayId) {
            this.displayId = displayId;
        }

        public String getDisplayId() {
            return this.displayId;
        }
    }

    public static class PullRequestsSummary {
        private final int count;
        private final String text;

        public PullRequestsSummary(int count, String text) {
            this.count = count;
            this.text = text;
        }

        public int getCount() {
            return this.count;
        }

        public String getText() {
            return this.text;
        }
    }
}

