/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.bitbucket.element;

import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.WebDriverLocatable;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.LegacyElementPageObject;
import java.util.List;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public abstract class AUIDialog
extends LegacyElementPageObject {
    protected PageElement dialogTitle;
    protected PageElement dialogPanelBody;
    protected PageElement cancelLink;
    protected PageElement mainActionButton;

    protected AUIDialog(PageElement container) {
        super(container);
    }

    public AUIDialog(By locator) {
        super(locator);
    }

    public AUIDialog(By locator, TimeoutType timeoutType) {
        super(locator, timeoutType);
    }

    public AUIDialog(WebDriverLocatable locatable, TimeoutType timeoutType) {
        super(locatable, timeoutType);
    }

    @Init
    private void bindComponents() {
        this.dialogTitle = this.find(this.getTitleLocator());
        this.dialogPanelBody = this.find(this.getPanelBodyLocator());
        this.cancelLink = this.find(this.getCancelLinkLocator());
        this.mainActionButton = this.find(this.getMainActionLocator());
    }

    @WaitUntil
    protected void waitUntilOpen() {
        Poller.waitUntilTrue((TimedQuery)this.isOpen());
    }

    protected void waitUntilBlanketHidden() {
        Poller.waitUntilTrue((TimedQuery)Conditions.forSupplier((long)5000L, () -> {
            List blankets = this.driver.findElements(By.className((String)"aui-blanket"));
            return blankets.isEmpty() || !((WebElement)blankets.get(0)).isDisplayed();
        }));
    }

    protected void waitUntilDismissed() {
        Poller.waitUntilFalse((TimedQuery)this.isOpen());
    }

    public TimedCondition isOpen() {
        return this.withTimeout(TimeoutType.DIALOG_LOAD).timed().isVisible();
    }

    public String getTitleText() {
        return this.dialogTitle.getText();
    }

    public String getPanelText() {
        return this.dialogPanelBody.getText();
    }

    public void clickCancel() {
        this.cancelLink.click();
        this.waitUntilDismissed();
        this.waitUntilBlanketHidden();
    }

    public void clickMainAction() {
        this.mainActionButton.click();
        this.waitUntilDismissed();
        this.waitUntilBlanketHidden();
    }

    public void clickMainActionExpectingAnotherDialog() {
        this.mainActionButton.click();
        this.waitUntilDismissed();
    }

    abstract By getTitleLocator();

    abstract By getPanelBodyLocator();

    abstract By getCancelLinkLocator();

    abstract By getMainActionLocator();
}

