/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.page;

import com.atlassian.bitbucket.pageobjects.element.ReactSelect;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.page.admin.BitbucketAdminPage;

public class KeysAndTokensPage
extends BitbucketAdminPage {
    @ElementBy(className="cancel-button")
    private PageElement CancelButton;
    @ElementBy(cssSelector="input[name='http-expiry-days']")
    private PageElement HTTPAccessTokensExpiryDays;
    @ElementBy(cssSelector="input[name='http-expiry'][value='Off']")
    private PageElement HTTPAccessTokensExpiryOffButton;
    @ElementBy(cssSelector="input[name='http-expiry'][value='On']")
    private PageElement HTTPAccessTokensExpiryOnButton;
    @ElementBy(className="keys-and-tokens-form")
    private PageElement KeysAndTokensForm;
    @ElementBy(cssSelector="input[name='ssh-expiry-days']")
    private PageElement SSHKeysExpiryDays;
    @ElementBy(cssSelector="input[name='ssh-expiry'][value='Off']")
    private PageElement SSHKeysExpiryOffButton;
    @ElementBy(className="submit-button")
    private PageElement SaveButton;
    @ElementBy(cssSelector="input[name='ssh-expiry'][value='On']")
    private PageElement SSHKeysExpiryOnButton;

    public KeysAndTokensPage() {
    }

    public KeysAndTokensPage(String webSudoPassword) {
        super(webSudoPassword);
    }

    public KeysAndTokensPage cancel() {
        this.CancelButton.click();
        return this;
    }

    public String getHTTPAccessTokensExpiryDays() {
        Poller.waitUntilTrue((TimedQuery)this.HTTPAccessTokensExpiryDays.timed().isVisible());
        return this.HTTPAccessTokensExpiryDays.getValue();
    }

    public TimedQuery<String> getKeyLength(String keyType) {
        ReactSelect keySelect = this.getKeySelect(keyType);
        return keySelect.getSelectedOption();
    }

    public KeysAndTokensPage setHTTPAccessTokensExpiryDays(String value) {
        Poller.waitUntilTrue((TimedQuery)this.HTTPAccessTokensExpiryDays.timed().isVisible());
        this.HTTPAccessTokensExpiryDays.clear().type(new CharSequence[]{value});
        return this;
    }

    public String getSSHKeysExpiryDays() {
        Poller.waitUntilTrue((TimedQuery)this.SSHKeysExpiryDays.timed().isVisible());
        return this.SSHKeysExpiryDays.getValue();
    }

    public String getUrl() {
        return "/admin/keys-and-tokens";
    }

    public TimedCondition isSaveButtonEnabled() {
        return this.SaveButton.timed().isEnabled();
    }

    public KeysAndTokensPage save() {
        this.SaveButton.click();
        return this;
    }

    public KeysAndTokensPage setHTTPAccessTokensExpiryOff() {
        Poller.waitUntilTrue((TimedQuery)this.HTTPAccessTokensExpiryOffButton.timed().isVisible());
        this.HTTPAccessTokensExpiryOffButton.click();
        return this;
    }

    public KeysAndTokensPage setSSHKeysExpiryDays(String value) {
        Poller.waitUntilTrue((TimedQuery)this.SSHKeysExpiryDays.timed().isVisible());
        this.SSHKeysExpiryDays.clear().type(new CharSequence[]{value});
        return this;
    }

    public KeysAndTokensPage setHTTPAccessTokensExpiryOn() {
        Poller.waitUntilTrue((TimedQuery)this.HTTPAccessTokensExpiryOnButton.timed().isVisible());
        this.HTTPAccessTokensExpiryOnButton.click();
        return this;
    }

    public KeysAndTokensPage setKeyTypeAndKeyLength(String keyType, String keyLength) {
        ReactSelect keySelect = this.getKeySelect(keyType);
        keySelect.selectOptionByPartialName(keyLength);
        return this;
    }

    public KeysAndTokensPage setSSHKeysExpiryOff() {
        Poller.waitUntilTrue((TimedQuery)this.SSHKeysExpiryOffButton.timed().isVisible());
        this.SSHKeysExpiryOffButton.click();
        return this;
    }

    public TimedCondition showSavedFlag() {
        return this.getFlags().get(0).isVisible();
    }

    public KeysAndTokensPage setSSHKeysExpiryOn() {
        Poller.waitUntilTrue((TimedQuery)this.SSHKeysExpiryOnButton.timed().isVisible());
        this.SSHKeysExpiryOnButton.click();
        return this;
    }

    private ReactSelect getKeySelect(String keyType) {
        return (ReactSelect)this.pageBinder.bind(ReactSelect.class, new Object[]{this.KeysAndTokensForm, keyType + "-key-select"});
    }
}

