/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element.codeinsights;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.TimedUtils;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.Optional;
import org.openqa.selenium.By;

public class CodeInsightsDiffAnnotation
extends AbstractElementPageObject {
    private final Integer lineNumber;
    private final PageElement separator = this.find(By.className((String)"separator"));
    private final PageElement severity = this.find(By.className((String)"severity-level"));

    public CodeInsightsDiffAnnotation(@Nonnull PageElement container) {
        this(container, null);
    }

    public CodeInsightsDiffAnnotation(@Nonnull PageElement container, Integer lineNumber) {
        super(container);
        this.lineNumber = lineNumber;
    }

    public Optional<Integer> getLineNumber() {
        return Optional.ofNullable(this.lineNumber);
    }

    public TimedQuery<String> getMessage() {
        return TimedUtils.toMappable(this.container.timed().getText()).map(it -> it.split(this.separator.getText())[1]);
    }

    public TimedQuery<String> getSeverity() {
        return TimedUtils.toMappable(this.severity.timed().getText()).map(it -> it.toUpperCase(Locale.US));
    }
}

