/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.element.PullRequestAvatar;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import com.atlassian.webdriver.bitbucket.util.Locators;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.openqa.selenium.By;

public class PullRequestList
extends AbstractElementPageObject {
    public PullRequestList(@Nonnull PageElement container) {
        super(container);
    }

    public TimedCondition isVisible() {
        return this.container.timed().isVisible();
    }

    public List<Entry> getRows() {
        Poller.waitUntilFalse((TimedQuery)this.container.find(By.className((String)"pull-requests-modal-spinner")).timed().isPresent());
        return Lists.transform((List)this.container.findAll(Locators.tableRow(), TimeoutType.PAGE_LOAD), ElementUtils.bind(this.pageBinder, Entry.class, new Object[0])::apply);
    }

    public static class Entry
    extends AbstractElementPageObject {
        private final String author = this.find(By.cssSelector((String)"td.avatar-column")).getAttribute("data-username");
        private final PageElement commentCount = this.find(By.cssSelector((String)"td.comments-column .count-value"));
        private final String status = this.find(By.cssSelector((String)"td.state-column")).getText();
        private final String targetBranch = this.find(By.cssSelector((String)".ref-lozenge-content")).getText();
        private final String title = this.find(By.cssSelector((String)".pr-summary > .title")).getText();

        public Entry(@Nonnull PageElement container) {
            super(container);
        }

        public String getAuthor() {
            return this.author;
        }

        public String getCommentCount() {
            return this.commentCount.getText();
        }

        public long getPullRequestId() {
            return Long.parseLong(this.container.getAttribute("data-pullrequestid"));
        }

        public List<PullRequestAvatar> getReviewers() {
            return (List)this.container.findAll(By.cssSelector((String)"[data-testid='reviewer-avatar']")).stream().map(ElementUtils.bind(this.pageBinder, PullRequestAvatar.class, new Object[0])).collect(MoreCollectors.toImmutableList());
        }

        public String getStatus() {
            return this.status;
        }

        public String getTargetBranch() {
            return this.targetBranch;
        }

        public String getTitle() {
            return this.title;
        }

        public boolean hasCommentCount() {
            return this.commentCount.isPresent();
        }

        public boolean hasDraftLozenge() {
            PageElement lozenge = this.container.find(By.cssSelector((String)".is-draft .details-item"));
            return (Boolean)lozenge.timed().hasText("DRAFT").byDefaultTimeout();
        }
    }
}

