/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.bitbucket.pageobjects.element.CodeMirrorEditor;
import com.atlassian.bitbucket.pageobjects.element.UserMultiSelector;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.List;
import org.openqa.selenium.By;

public class PullRequestEditDialog
extends AbstractElementPageObject {
    private final PageElement description = this.find(By.className((String)"CodeMirror-code"));
    private final PageElement destinationSelect = this.find(By.className((String)"target-branch-selector"));
    private final PageElement reviewerSelect = this.find(By.className((String)"user-multi-select"));
    private final PageElement save = this.find(By.cssSelector((String)"[type=submit]"));
    private final PageElement title = this.find(By.id((String)"pull-request-title"));
    private final PageElement toolbar = this.find(By.className((String)"editor-toolbar-primary"));
    @Inject
    private PageElementFinder elementFinder;

    public PullRequestEditDialog(@Nonnull PageElementFinder elementFinder) {
        super(elementFinder.find(By.cssSelector((String)"[data-testid='edit-pull-request-modal']")));
    }

    public PullRequestEditDialog addReviewer(String reviewer) {
        this.getReviewerSelector().addUser(reviewer);
        return this;
    }

    public PullRequestEditDialog changeDescription(String newDescription) {
        this.description.withTimeout(TimeoutType.UI_ACTION).click();
        CodeMirrorEditor editor = (CodeMirrorEditor)this.pageBinder.bind(CodeMirrorEditor.class, new Object[]{this.container});
        editor.setText(newDescription);
        return this;
    }

    public PullRequestEditDialog changeDestination(String destinationBranch) {
        this.destinationSelect.click().find(By.cssSelector((String)"input")).type(new CharSequence[]{destinationBranch});
        PageElement newDestinationElement = this.elementFinder.find(By.cssSelector((String)("[data-test-label='" + destinationBranch + "']")));
        Poller.waitUntilTrue((TimedQuery)newDestinationElement.timed().isPresent());
        Poller.waitUntilTrue((TimedQuery)newDestinationElement.timed().isVisible());
        newDestinationElement.click();
        return this;
    }

    public void createTable(String cellId) {
        PageElement tableSelector = this.elementFinder.find(By.id((String)"table-formatting-popup"));
        tableSelector.find(By.id((String)cellId)).click();
    }

    public UserMultiSelector getReviewerSelector() {
        return (UserMultiSelector)this.pageBinder.bind(UserMultiSelector.class, new Object[]{this.reviewerSelect});
    }

    public List<String> getReviewerUsernames() {
        return (List)this.getReviewerSelector().getValues().stream().map(reviewer -> reviewer.getName()).collect(MoreCollectors.toImmutableList());
    }

    public PageElement getToolbarButton(String buttonId) {
        return this.toolbar.find(By.id((String)buttonId));
    }

    public PullRequestEditDialog handleSelection(int start, int end, int line) {
        this.description.withTimeout(TimeoutType.UI_ACTION).click();
        CodeMirrorEditor editor = (CodeMirrorEditor)this.pageBinder.bind(CodeMirrorEditor.class, new Object[]{this.container});
        editor.selectText(start, end, line);
        return this;
    }

    public PullRequestEditDialog removeReviewer(String reviewer) {
        this.getReviewerSelector().removeUser(reviewer);
        return this;
    }

    public void save() {
        this.save.withTimeout(TimeoutType.UI_ACTION).click();
    }

    public PullRequestEditDialog setTitle(String title) {
        this.title.clear();
        this.title.type(new CharSequence[]{title});
        return this;
    }
}

