/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pageobjects.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.webdriver.bitbucket.element.AbstractElementPageObject;
import com.atlassian.webdriver.bitbucket.element.LinkElement;
import com.atlassian.webdriver.bitbucket.util.ElementUtils;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.stream.Collectors;
import org.openqa.selenium.By;

public class DiffSearchResults
extends AbstractElementPageObject {
    public DiffSearchResults(@Nonnull PageElement container) {
        super(container);
    }

    public List<FileResult> getFileResults() {
        this.waitUntilReady();
        return this.container.findAll(By.className((String)"search-result-file")).stream().map(ElementUtils.bind(this.pageBinder, FileResult.class, new Object[0])).collect(Collectors.toList());
    }

    public boolean hasNoResults() {
        this.waitUntilReady();
        return this.find(By.cssSelector((String)"[data-testid='no-search-results']")).isPresent();
    }

    private void waitUntilReady() {
        Poller.waitUntilFalse((TimedQuery)this.find(By.className((String)"centered-spinner")).timed().isVisible());
    }

    public static class FileResult
    extends AbstractElementPageObject {
        public FileResult(@Nonnull PageElement container) {
            super(container);
        }

        public String getFileName() {
            return this.find(By.cssSelector((String)".file-title .file-name")).getText();
        }

        public int getResultCount() {
            return Integer.parseInt(this.find(By.cssSelector((String)"[data-testid='file-result-count']")).getText());
        }

        public List<ResultLine> getResultLines() {
            return this.container.findAll(By.className((String)"search-result-line")).stream().map(ElementUtils.bind(this.pageBinder, ResultLine.class, new Object[0])).collect(Collectors.toList());
        }
    }

    public static class ResultLine
    extends AbstractElementPageObject {
        public ResultLine(@Nonnull PageElement container) {
            super(container);
        }

        public String getHighlightedText() {
            return this.find(By.tagName((String)"mark")).getText();
        }

        public LinkElement getResultLink() {
            return (LinkElement)((Object)this.pageBinder.bind(LinkElement.class, new Object[]{this.getResultLinkElement()}));
        }

        public boolean isActive() {
            return this.getResultLinkElement().hasClass("active");
        }

        private PageElement getResultLinkElement() {
            return this.find(By.className((String)"result-link"));
        }
    }
}

