/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.user.InternalGrantedPermission;
import com.atlassian.stash.internal.user.InternalGrantedPermissionVisitor;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@Entity
@Table(name="sta_repo_permission", indexes={@Index(name="idx_repo_permission_user", columnList="user_id"), @Index(name="idx_repo_permission_group", columnList="group_name")})
public class InternalRepositoryPermission
extends InternalGrantedPermission {
    static final String TABLE = "sta_repo_permission";
    @JoinColumn(name="repo_id")
    @ManyToOne(fetch=FetchType.LAZY)
    private final InternalRepository repository;

    protected InternalRepositoryPermission() {
        this.repository = null;
    }

    @Override
    public void accept(@Nonnull InternalGrantedPermissionVisitor visitor) {
        visitor.visit(this);
    }

    private InternalRepositoryPermission(Long id, Permission permission, InternalRepository repository, String group, InternalApplicationUser user) {
        super(id, permission, group, user);
        this.repository = repository;
    }

    @Nonnull
    public InternalRepository getRepository() {
        return this.repository;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof InternalRepositoryPermission) {
            InternalRepositoryPermission that = (InternalRepositoryPermission)o;
            return Objects.equals(this.getPermission(), that.getPermission()) && Objects.equals(this.getGroup(), that.getGroup()) && Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getRepository(), that.getRepository()) && Objects.equals(this.getUser(), that.getUser());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getPermission(), this.getGroup(), this.getId(), this.getRepository(), this.getUser());
    }

    public static final class Builder
    extends InternalGrantedPermission.AbstractBuilder<Builder> {
        private InternalRepository repository;

        public Builder() {
        }

        public Builder(InternalRepositoryPermission source) {
            super(source);
            this.repository = source.getRepository();
        }

        public InternalRepositoryPermission build() {
            return new InternalRepositoryPermission(this.id, this.permission, this.repository, this.group, this.user);
        }

        public Builder repository(InternalRepository repository) {
            this.repository = repository;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

