/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.config.rest;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.RestErrors;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.stash.internal.jira.config.DevSummaryPluginSettings;
import com.atlassian.stash.internal.jira.config.InvalidPropertyException;
import com.atlassian.stash.internal.jira.config.RepoProperties;
import com.atlassian.stash.internal.jira.config.json.RepoProperty;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.spi.resource.Singleton;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class DevSummaryRepositoryPropertiesResource {
    private final DevSummaryPluginSettings devSummaryPluginSettingsService;

    public DevSummaryRepositoryPropertiesResource(DevSummaryPluginSettings devSummaryPluginSettingsService) {
        this.devSummaryPluginSettingsService = devSummaryPluginSettingsService;
    }

    @Path(value="/properties/{name}")
    @GET
    public Response getProperty(@Context Repository repository, @PathParam(value="name") String name) {
        RepoProperties property = this.getProperty(name);
        String value = this.devSummaryPluginSettingsService.get(repository, property.getKey(), property.getDefaultValue());
        return ResponseFactory.ok((Object)((Object)new RepoProperty(property.getKey(), value, property.getDefaultValue()))).build();
    }

    @Path(value="/properties")
    @GET
    public Response listProperties(@Context Repository repository) {
        ArrayList<RepoProperty> properties = new ArrayList<RepoProperty>();
        for (RepoProperties p : RepoProperties.values()) {
            String value = this.devSummaryPluginSettingsService.get(repository, p.getKey(), p.getDefaultValue());
            properties.add(new RepoProperty(p.getKey(), value, p.getDefaultValue()));
        }
        return ResponseFactory.ok(properties).build();
    }

    @Path(value="/properties")
    @PUT
    public Response setProperty(@Context Repository repository, RepoProperty property) {
        try {
            RepoProperties repoProperty = this.getProperty(property.getName());
            this.devSummaryPluginSettingsService.put(repository, repoProperty.getKey(), property.getValue(), repoProperty.getType());
            return ResponseFactory.ok((Object)((Object)new RepoProperty(repoProperty.getKey(), property.getValue(), repoProperty.getDefaultValue()))).build();
        }
        catch (InvalidPropertyException e) {
            RestErrors errors = new RestErrors(e.getMessage());
            Response response = ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)errors).build();
            throw new WebApplicationException(response);
        }
    }

    @Path(value="/properties/{name}")
    @DELETE
    public Response removeProperty(@Context Repository repository, @PathParam(value="name") String name) {
        RepoProperties property = this.getProperty(name);
        this.devSummaryPluginSettingsService.remove(repository, property.getKey());
        ImmutableMap map = ImmutableMap.of((Object)"message", (Object)String.format("Property %s removed successfully for %s/%s", property.getKey(), repository.getProject().getKey(), repository.getSlug()));
        return ResponseFactory.ok((Object)map).build();
    }

    private RepoProperties getProperty(String propertyName) {
        RepoProperties property = RepoProperties.getByKey(propertyName);
        if (property == null) {
            RestErrors errors = new RestErrors("Invalid property name: " + propertyName);
            Response response = ResponseFactory.errors((Response.Status)Response.Status.BAD_REQUEST, (RestErrors)errors).build();
            throw new WebApplicationException(response);
        }
        return property;
    }
}

