/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.depview.osgi;

import java.util.Collection;
import javax.annotation.Nonnull;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public enum WireDirection {
    PROVIDED,
    REQUIRED;


    public Collection<BundleWire> getWires(@Nonnull BundleWiring wiring) {
        switch (this) {
            case PROVIDED: {
                return wiring.getProvidedWires(null);
            }
            case REQUIRED: {
                return wiring.getRequiredWires(null);
            }
        }
        throw new UnsupportedOperationException("getWires not supported for " + (Object)((Object)this));
    }

    public Bundle getBundle(BundleWire wire) {
        switch (this) {
            case PROVIDED: {
                return wire.getRequirerWiring().getBundle();
            }
            case REQUIRED: {
                return wire.getProviderWiring().getBundle();
            }
        }
        throw new UnsupportedOperationException("getBundle not supported for " + (Object)((Object)this));
    }

    public ServiceReference[] getServices(Bundle bundle) {
        switch (this) {
            case PROVIDED: {
                return bundle.getRegisteredServices();
            }
            case REQUIRED: {
                return bundle.getServicesInUse();
            }
        }
        throw new UnsupportedOperationException("getServices not supported for " + (Object)((Object)this));
    }
}

