/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.database.console.spring;

import com.atlassian.database.console.connection.context.AchooExecutor;
import com.atlassian.database.console.connection.context.BambooAchooExecutor;
import com.atlassian.database.console.connection.context.ConfluenceAchooExecutor;
import com.atlassian.database.console.connection.context.CrowdAchooExecutor;
import com.atlassian.database.console.connection.provider.AchooConnectionProvider;
import com.atlassian.database.console.connection.provider.ConfluenceConnectionProvider;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BambooOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BitbucketOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.ConfluenceOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.CrowdOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.FecruOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.JiraOnly;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.RefappOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.rdbms.TransactionalExecutor;
import com.atlassian.sal.api.rdbms.TransactionalExecutorFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserManager;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SpringConfig {
    @Bean
    public ApplicationProperties applicationProperties() {
        return (ApplicationProperties)OsgiServices.importOsgiService(ApplicationProperties.class);
    }

    @Bean
    public TransactionalExecutorFactory transactionalExecutorFactory() {
        return (TransactionalExecutorFactory)OsgiServices.importOsgiService(TransactionalExecutorFactory.class);
    }

    @Bean
    public TransactionTemplate transactionTemplate() {
        return (TransactionTemplate)OsgiServices.importOsgiService(TransactionTemplate.class);
    }

    @Bean
    public UserManager userManager() {
        return (UserManager)OsgiServices.importOsgiService(UserManager.class);
    }

    @Bean(value={"achooExecutor"})
    @Conditional(value={BambooOnly.class})
    public AchooExecutor bambooAchooExecutor(TransactionTemplate transactionTemplate) {
        return new BambooAchooExecutor(transactionTemplate);
    }

    @Bean(value={"achooExecutor"})
    @Conditional(value={BitbucketOnly.class})
    public AchooExecutor bitbucketAchooExecutor() {
        return runnable -> {};
    }

    @Bean(value={"achooExecutor"})
    @Conditional(value={ConfluenceOnly.class})
    public AchooExecutor confluenceAchooExecutor(TransactionalExecutorFactory transactionalExecutorFactory, TransactionTemplate transactionTemplate) {
        TransactionalExecutor transactionalExecutor = transactionalExecutorFactory.create();
        return new ConfluenceAchooExecutor(transactionalExecutor, transactionTemplate);
    }

    @Bean(value={"achooExecutor"})
    @Conditional(value={CrowdOnly.class})
    public AchooExecutor crowdAchooExecutor() {
        return new CrowdAchooExecutor();
    }

    @Bean(value={"achooExecutor"})
    @Conditional(value={FecruOnly.class})
    public AchooExecutor feCruAchooExecutor() {
        return runnable -> {};
    }

    @Bean(value={"achooExecutor"})
    @Conditional(value={JiraOnly.class})
    public AchooExecutor jiraAchooExecutor() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> databaseAccessorClass = Class.forName("com.atlassian.jira.database.DatabaseAccessor");
        Object databaseAccessorObject = OsgiServices.importOsgiService(databaseAccessorClass);
        Class<?> jiraAchooExecutorClass = Class.forName("com.atlassian.database.console.connection.context.JiraAchooExecutor");
        Constructor<?> constructor = jiraAchooExecutorClass.getDeclaredConstructor(databaseAccessorClass);
        return (AchooExecutor)constructor.newInstance(databaseAccessorObject);
    }

    @Bean(value={"achooExecutor"})
    @Conditional(value={RefappOnly.class})
    public AchooExecutor refappAchooExecutor() {
        return Runnable::run;
    }

    @Bean(value={"achooConnectionProvider"})
    @Conditional(value={BambooOnly.class})
    public AchooConnectionProvider bambooAchooConnectionProvider() throws Exception {
        Class<?> pluginHibernateSessionFactoryClass = Class.forName("com.atlassian.bamboo.persistence3.PluginHibernateSessionFactory");
        Object pluginHibernateSessionFactoryObject = OsgiServices.importOsgiService(pluginHibernateSessionFactoryClass);
        Class<?> achooConnectionProviderClass = Class.forName("com.atlassian.database.console.connection.provider.BambooConnectionProvider");
        Constructor<?> constructor = achooConnectionProviderClass.getDeclaredConstructor(pluginHibernateSessionFactoryClass);
        return (AchooConnectionProvider)constructor.newInstance(pluginHibernateSessionFactoryObject);
    }

    @Bean(value={"achooConnectionProvider"})
    @Conditional(value={BitbucketOnly.class})
    public AchooConnectionProvider bitbucketAchooConnectionProvider() {
        return () -> null;
    }

    @Bean(value={"achooConnectionProvider"})
    @Conditional(value={ConfluenceOnly.class})
    public AchooConnectionProvider confluenceAchooConnectionProvider() {
        return new ConfluenceConnectionProvider();
    }

    @Bean(value={"achooConnectionProvider"})
    @Conditional(value={CrowdOnly.class})
    public AchooConnectionProvider crowdConnectionProvider() throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Class<?> tenantAwareDataSourceProviderClass = Class.forName("com.atlassian.activeobjects.spi.TenantAwareDataSourceProvider");
        Object tenantAwareDataSourceProviderObject = OsgiServices.importOsgiService(tenantAwareDataSourceProviderClass);
        Class<?> achooConnectionProviderClass = Class.forName("com.atlassian.database.console.connection.provider.CrowdConnectionProvider");
        Constructor<?> constructor = achooConnectionProviderClass.getDeclaredConstructor(tenantAwareDataSourceProviderClass);
        return (AchooConnectionProvider)constructor.newInstance(tenantAwareDataSourceProviderObject);
    }

    @Bean(value={"achooConnectionProvider"})
    @Conditional(value={FecruOnly.class})
    public AchooConnectionProvider feCruAchooConnectionProvider() {
        return () -> null;
    }

    @Bean(value={"achooConnectionProvider"})
    @Conditional(value={JiraOnly.class})
    public AchooConnectionProvider jiraConnectionProvider() throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> achooConnectionProviderClass = Class.forName("com.atlassian.database.console.connection.provider.JiraConnectionProvider");
        return (AchooConnectionProvider)achooConnectionProviderClass.newInstance();
    }

    @Bean(value={"achooConnectionProvider"})
    @Conditional(value={RefappOnly.class})
    public AchooConnectionProvider refappAchooConnectionProvider() throws Exception {
        Class<?> refAppconnectionProviderClass = Class.forName("com.atlassian.refapp.api.ConnectionProvider");
        Object connectionProviderObject = OsgiServices.importOsgiService(refAppconnectionProviderClass);
        Class<?> achooConnectionProviderClass = Class.forName("com.atlassian.database.console.connection.provider.RefAppConnectionProvider");
        Constructor<?> constructor = achooConnectionProviderClass.getDeclaredConstructor(refAppconnectionProviderClass);
        return (AchooConnectionProvider)constructor.newInstance(connectionProviderObject);
    }
}

